/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.mirror;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.config.ConfigOptions;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.mirror.IExecutor;
import xyz.nifeather.morph.mirror.IOperationHandle;
import xyz.nifeather.morph.mirror.impl.executors.ByNameExecutor;
import xyz.nifeather.morph.mirror.impl.executors.ByRangeExecutor;
import xyz.nifeather.morph.mirror.impl.executors.BySightExecutor;
import xyz.nifeather.morph.mirror.impl.simulator.FallbackOperationHandle;
import xyz.nifeather.morph.mirror.impl.simulator.MannequinOperationHandle;
import xyz.nifeather.morph.mirror.impl.simulator.PlayerOperationHandle;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.storage.DirectoryStorage;
import xyz.nifeather.morph.storage.mirrorlogging.MirrorSingleEntry;
import xyz.nifeather.morph.storage.mirrorlogging.OperationType;

public class ExecutorHub
extends MorphPluginObject {
    private final ConcurrentHashMap<String, IExecutor<Player, ItemStack, Action>> executorMap = new ConcurrentHashMap();
    public final Bindable<Boolean> logOperations = new Bindable<Boolean>(false);
    public final Bindable<Integer> cleanUpDate = new Bindable<Integer>(3);
    public final Bindable<Integer> controlRange = new Bindable<Integer>(0);
    private final Map<Player, String> mirrorMap = new ConcurrentHashMap<Player, String>();
    private final Map<EntityType, IOperationHandle<?>> operationHandleMap = new ConcurrentHashMap();
    private final DirectoryStorage logStore = new DirectoryStorage("logs");
    private final Map<Player, Stack<MirrorSingleEntry>> tempEntries = new Object2ObjectOpenHashMap();
    private final SimpleDateFormat logFileTimeFormat = new SimpleDateFormat("yyyy-MM-dd");
    private File loggingTargetFile;
    private String currentLogDate = "0000-00-00";

    public ExecutorHub() {
        this.registerExecutor("BY_NAME", new ByNameExecutor(this));
        this.registerExecutor("BY_SIGHT", new BySightExecutor(this));
        this.registerExecutor("BY_RANGE", new ByRangeExecutor(this));
    }

    @Initializer
    private void load(MorphConfigManager config) {
        this.addSchedule(this::update);
        config.bind(this.logOperations, ConfigOptions.MIRROR_LOG_OPERATION);
        config.bind(this.cleanUpDate, ConfigOptions.MIRROR_LOG_CLEANUP_DATE);
        config.bind(this.controlRange, ConfigOptions.MIRROR_CONTROL_DISTANCE);
        this.initOperationHandleMap();
    }

    private void update() {
        this.addSchedule(this::update);
        if (this.plugin.getCurrentTick() % 100L == 0L) {
            this.pushToLoggingBase();
        }
    }

    public void registerExecutor(String name, IExecutor<Player, ItemStack, Action> executor) {
        this.executorMap.put(name, executor);
    }

    @Nullable
    public IExecutor<Player, ItemStack, Action> getExecutor(String name) {
        return this.executorMap.getOrDefault(name.toUpperCase(), null);
    }

    public void executeIfExists(String executorName, Consumer<IExecutor<Player, ItemStack, Action>> consumer) {
        IExecutor<Player, ItemStack, Action> executor = this.getExecutor(executorName);
        if (executor != null) {
            consumer.accept(executor);
        }
    }

    public void registerControl(Player player, @Nullable String targetName) {
        if (targetName == null || targetName.isBlank()) {
            this.mirrorMap.remove(player);
        } else {
            this.mirrorMap.put(player, targetName);
        }
    }

    public void unregisterControl(Player player) {
        this.registerControl(player, null);
    }

    @Nullable
    public String getControl(Player player) {
        return this.mirrorMap.getOrDefault(player, null);
    }

    public int getControlDistance() {
        return this.controlRange.get();
    }

    private void initOperationHandleMap() {
        this.operationHandleMap.put(EntityType.PLAYER, new PlayerOperationHandle());
        this.operationHandleMap.put(EntityType.MANNEQUIN, new MannequinOperationHandle());
    }

    @NotNull
    public <E extends LivingEntity> IOperationHandle<E> lookupOperationHandle(E mirrorableEntity) {
        for (Map.Entry<EntityType, IOperationHandle<?>> entry : this.operationHandleMap.entrySet()) {
            if (!entry.getKey().equals((Object)mirrorableEntity.getType())) continue;
            return entry.getValue();
        }
        if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
            this.logger.error("No simulator found for entity %s".formatted(mirrorableEntity));
        }
        return FallbackOperationHandle.INSTANCE;
    }

    private void cleanUpLogFiles(int days) {
        if (days <= 0) {
            return;
        }
        File[] files = this.logStore.getFiles("mirror-[0-9]{4}-[0-9]{2}-[0-9]{2}.log");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -days);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date targetDate = calendar.getTime();
        for (File file : files) {
            Date date;
            String[] splitName = file.getName().split("-");
            if (splitName.length < 4) continue;
            String formattedName = "%s-%s-%s".formatted(splitName[1], splitName[2], splitName[3]);
            if (formattedName.equals(this.currentLogDate)) continue;
            try {
                date = this.logFileTimeFormat.parse(formattedName);
            }
            catch (ParseException e) {
                this.logger.error("Unable to determine creation date for InteractionMirror log file '%s'".formatted(file.getName()), (Throwable)e);
                continue;
            }
            if (date.after(targetDate)) continue;
            this.logger.info("Removing InteractionMirror log '%s' as it's older than %s day(s)".formatted(file.getName(), days));
            if (file.delete()) continue;
            this.logger.warn("Unable to remove file: Unknown error");
        }
    }

    private void updateTargetFile() {
        boolean createNew;
        this.cleanUpLogFiles(this.cleanUpDate.get());
        String targetLogDate = this.logFileTimeFormat.format(new Date(System.currentTimeMillis()));
        boolean bl = createNew = !targetLogDate.equals(this.currentLogDate);
        if (!createNew) {
            return;
        }
        this.currentLogDate = targetLogDate;
        this.loggingTargetFile = this.logStore.getFile("mirror-%s.log".formatted(targetLogDate), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushToLoggingBase() {
        if (this.logStore.initializeFailed()) {
            return;
        }
        if (this.loggingTargetFile == null) {
            this.updateTargetFile();
        }
        Map<Player, Stack<MirrorSingleEntry>> map = this.tempEntries;
        synchronized (map) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
            if (this.tempEntries.isEmpty()) {
                return;
            }
            try (FileOutputStream stream = new FileOutputStream(this.loggingTargetFile, true);){
                this.tempEntries.forEach((p, stack) -> {
                    for (MirrorSingleEntry entry : stack) {
                        Object msg = "";
                        msg = (String)msg + "[%s] %s triggered operation %s for player %s repeating %s time(s).\n".formatted(new Object[]{dateFormat.format(new Date(entry.timeMills())), entry.playerName(), entry.operationType(), entry.targetPlayerName(), entry.repeatingTimes()});
                        try {
                            stream.write(((String)msg).getBytes());
                        }
                        catch (IOException e) {
                            this.logger.error("Error occurred while saving logs", (Throwable)e);
                        }
                    }
                });
            }
            catch (IOException e) {
                this.logger.error("Error occurred while saving logs", (Throwable)e);
            }
            this.tempEntries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private MirrorSingleEntry getOrCreateEntryFor(Player player, LivingEntity targetPlayer, OperationType type) {
        Map<Player, Stack<MirrorSingleEntry>> map = this.tempEntries;
        synchronized (map) {
            MirrorSingleEntry peek;
            Stack<MirrorSingleEntry> playerStack = this.tempEntries.getOrDefault(player, null);
            if (playerStack == null) {
                playerStack = new Stack<MirrorSingleEntry>();
                this.tempEntries.put(player, playerStack);
            }
            MirrorSingleEntry entry = null;
            if (!playerStack.isEmpty() && (peek = (MirrorSingleEntry)playerStack.peek()).uuid().equals(player.getUniqueId().toString()) && peek.targetPlayerName().equals(targetPlayer.getName()) && peek.operationType() == type) {
                entry = peek;
            }
            if (entry != null) {
                return entry;
            }
            entry = new MirrorSingleEntry(player.getName(), player.getUniqueId().toString(), targetPlayer.getName(), type, 0, System.currentTimeMillis());
            playerStack.push(entry);
            return entry;
        }
    }

    public void logOperation(Player source, LivingEntity targetPlayer, OperationType type) {
        if (!this.logOperations.get().booleanValue()) {
            return;
        }
        MirrorSingleEntry entry = this.getOrCreateEntryFor(source, targetPlayer, type);
        entry.increaseRepeatingTimes();
    }
}

