/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.mirror.impl.executors;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import net.minecraft.world.level.GameType;
import org.bukkit.GameMode;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.events.PlayerTracker;
import xyz.nifeather.morph.mirror.ExecutorHub;
import xyz.nifeather.morph.mirror.impl.executors.ChainedExecutor;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.NmsRecord;
import xyz.nifeather.morph.storage.mirrorlogging.OperationType;
import xyz.nifeather.morph.utilities.FoliaThreadUtils;

public class ByRangeExecutor
extends ChainedExecutor {
    public ByRangeExecutor(ExecutorHub executorHub) {
        super(executorHub);
    }

    @Override
    @Nullable
    protected LivingEntity findNextControllableEntityFrom(Player source, List<LivingEntity> pendingChain) {
        int index = pendingChain.indexOf(source);
        if (index == -1 || index >= pendingChain.size()) {
            return null;
        }
        return pendingChain.get(index + 1);
    }

    @Override
    protected List<LivingEntity> buildSimulateChain(Player source) {
        Collection matchedPlayers;
        block4: {
            int controlDistance;
            String targetName = this.executorHub.getControl(source);
            if (targetName == null) {
                targetName = source.getName();
            }
            if ((controlDistance = this.executorHub.getControlDistance()) == -1) {
                controlDistance = 32;
            }
            String finalTargetName = targetName;
            int finalControlDistance = controlDistance;
            matchedPlayers = null;
            try {
                matchedPlayers = FoliaThreadUtils.runOnEntitySync(source, src -> src.getWorld().getNearbyPlayers(src.getLocation(), (double)finalControlDistance, candidatePlayer -> {
                    if (Objects.equals(candidatePlayer, src)) {
                        return false;
                    }
                    if (NmsRecord.ofPlayer((Player)candidatePlayer).gameMode.getGameModeForPlayer() == GameType.SPECTATOR) {
                        return false;
                    }
                    DisguiseState theirState = this.morphManager().getDisguiseStateFor((Player)candidatePlayer);
                    if (theirState != null && theirState.getDisguiseIdentifier().equals("player:" + finalTargetName)) {
                        return true;
                    }
                    return candidatePlayer.getName().equals(finalTargetName) && theirState == null;
                }), FoliaThreadUtils.DEFAULT_WAIT_TIMEOUT);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                if (!FeatherMorphMain.getInstance().debugOutputEnabled()) break block4;
                this.logger.error("Failed to build byRange simulate chain", (Throwable)e);
            }
        }
        ObjectArrayList list = new ObjectArrayList();
        list.add((Object)source);
        list.addAll(matchedPlayers);
        return list;
    }

    @Override
    public boolean onSwing(Player source) {
        boolean isInChain = this.isInChain((LivingEntity)source);
        if (isInChain) {
            return false;
        }
        PlayerTracker tracker = this.tracker();
        if (tracker.droppingItemThisTick(source)) {
            return false;
        }
        PlayerTracker.InteractType lastAction = tracker.getLastInteractAction(source);
        if (!tracker.interactingThisTick(source)) {
            lastAction = PlayerTracker.InteractType.LEFT_CLICK_AIR;
        }
        if (lastAction == null) {
            return false;
        }
        if (source.getGameMode() == GameMode.SPECTATOR && lastAction.isRightClick()) {
            lastAction = PlayerTracker.InteractType.LEFT_CLICK_BLOCK;
        }
        PlayerTracker.InteractType finalLastAction = lastAction;
        this.runIfChainable(source, targetPlayer -> {
            this.simulateOperation(finalLastAction.toBukkitAction(), targetPlayer, source);
            this.logOperation(source, (LivingEntity)targetPlayer, finalLastAction.isLeftClick() ? OperationType.LeftClick : OperationType.RightClick);
        });
        return false;
    }

    @Override
    public boolean onHurtEntity(Player damager, LivingEntity hurted) {
        return !this.isInChain((LivingEntity)damager) || !this.isInChain(hurted);
    }

    @Override
    public void reset() {
    }
}

