/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty;

import com.mojang.authlib.GameProfile;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import java.util.EnumSet;
import java.util.Objects;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import xyz.nifeather.morph.messages.strings.CommandStrings;
import xyz.nifeather.morph.messages.strings.ExceptionStrings;
import xyz.nifeather.morph.misc.DisguiseEquipment;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyValidationException;
import xyz.nifeather.morph.misc.disguiseProperty.ValidationFlag;
import xyz.nifeather.morph.misc.skins.PlayerSkinProvider;
import xyz.nifeather.morph.utilities.Uuids;

public class PropertyValidations {
    public static void noOp(Object value, Player player, EnumSet<ValidationFlag> validationFlags) {
    }

    public static void validateCustomTextPermission(Object value, Player player, EnumSet<ValidationFlag> validationFlags) throws PropertyValidationException {
        if (validationFlags.contains((Object)ValidationFlag.SKIP_PERMISSIONS)) {
            return;
        }
        if (!player.hasPermission("feathermorph.custom_text")) {
            throw PropertyValidationException.forProperty("entity/custom_name").byMethod("validateCustomTextPermission").withLocalizableMessage(CommandStrings.noPermissionMessage()).withMessage("Player don't have permission setting custom name for disguise").create();
        }
    }

    public static void validatePlayerSkin(GameProfile skin, Player player, EnumSet<ValidationFlag> validationFlags) throws PropertyValidationException {
        boolean skinMatchesCache;
        if (!(validationFlags.contains((Object)ValidationFlag.SKIP_PERMISSIONS) || (skinMatchesCache = Objects.equals(PlayerSkinProvider.getInstance().getCachedProfile(skin.name()), skin)) || player.hasPermission("feathermorph.custom_skin"))) {
            throw PropertyValidationException.forProperty("mannequin/skin").byMethod("validatePlayerSkin").withLocalizableMessage(CommandStrings.noPermissionMessage()).withMessage("Player don't have permission for setting custom skin").create();
        }
        if (skin.id().equals(Uuids.NIL_UUID)) {
            throw PropertyValidationException.forProperty("player/skin").byMethod("validatePlayerSkin").withLocalizableMessage(ExceptionStrings.inputNotAllowed()).withMessage("UUID of the skin may not be ZERO").create();
        }
    }

    public static void validateMannequinCustomSkinPermission(Object any, Player player, EnumSet<ValidationFlag> validationFlags) throws PropertyValidationException {
        if (validationFlags.contains((Object)ValidationFlag.SKIP_PERMISSIONS)) {
            return;
        }
        if (!player.hasPermission("feathermorph.custom_skin")) {
            throw PropertyValidationException.forProperty("mannequin/skin").byMethod("validateMannequinCustomSkinPermission").withLocalizableMessage(CommandStrings.noPermissionMessage()).withMessage("Player don't have permission for setting custom skin").create();
        }
    }

    public static void validateEquipment(DisguiseEquipment equipment, Player player, EnumSet<ValidationFlag> validationFlags) throws PropertyValidationException {
        if (validationFlags.contains((Object)ValidationFlag.SKIP_PERMISSIONS)) {
            return;
        }
        for (ItemStack stack : equipment.contents().values()) {
            ResolvableProfile data = (ResolvableProfile)stack.getData(DataComponentTypes.PROFILE);
            if (data == null || player.hasPermission("feathermorph.disguise_properties.custom_skin_on_items")) continue;
            throw PropertyValidationException.forProperty("entity/equipment").byMethod("validateEquipment").withLocalizableMessage(CommandStrings.noPermissionMessage()).withMessage("Player don't have permission setting custom skin profile for items").create();
        }
    }
}

