/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityPropertyCollection;
import xyz.nifeather.morph.utilities.DisguiseUtils;

public class AxolotlPropertyCollection
extends BaseLivingEntityPropertyCollection<Axolotl> {
    private final Map<String, Axolotl.Variant> variantMap = new ConcurrentHashMap<String, Axolotl.Variant>();
    public final SingleProperty<Axolotl.Variant> VARIANT;

    private void initVariantMap() {
        for (Axolotl.Variant variant : Axolotl.Variant.values()) {
            this.variantMap.put(variant.name().toLowerCase(), variant);
        }
    }

    public Optional<Axolotl.Variant> readAxolotlVariant(String propertyName, String input) throws ParseErrorException {
        return InputHandles.readEnumNonNull((Enum[])Axolotl.Variant.values(), (String)propertyName, (String)input);
    }

    public AxolotlPropertyCollection() {
        this.initVariantMap();
        this.VARIANT = SingleProperty.builder("axolotl/variant", Axolotl.Variant.LUCY).withInputHandle(this::readAxolotlVariant).withOutputHandle(OutputHandles::writeEnum).withRandom((Axolotl.Variant[])Axolotl.Variant.values()).withSuggestions(this.variantMap.keySet()).build();
        this.registerSingle((SingleProperty<?>)this.VARIANT);
    }

    @Override
    @Nullable
    protected Axolotl tryCastEntity(@Nullable Entity targetEntity) {
        Axolotl axolotl;
        return targetEntity instanceof Axolotl ? (axolotl = (Axolotl)targetEntity) : null;
    }

    @Override
    public void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Axolotl axolotl) {
        super.setupPropertiesFromEntity(meta, propertyHandler, axolotl);
        propertyHandler.set(this.VARIANT, axolotl.getVariant());
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        propertyHandler.set(this.VARIANT, DisguiseUtils.pick(this.VARIANT.randomValues()));
    }
}

