/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityPropertyCollection;
import xyz.nifeather.morph.utilities.DisguiseUtils;

public class CowPropertyCollection
extends BaseLivingEntityPropertyCollection<Cow> {
    private final Map<String, Cow.Variant> variantMap = new ConcurrentHashMap<String, Cow.Variant>();
    public final SingleProperty<Cow.Variant> VARIANT;

    public CowPropertyCollection() {
        for (Cow.Variant variant : RegistryAccess.registryAccess().getRegistry(RegistryKey.COW_VARIANT)) {
            this.variantMap.put(variant.key().asString(), variant);
        }
        this.VARIANT = SingleProperty.builder("cow/variant", Cow.Variant.TEMPERATE).withInputHandle(this::readCowVariant).withOutputHandle(OutputHandles::writeKeyed).withRandom(this.variantMap.values()).withSuggestions(this.variantMap.keySet()).build();
        this.registerSingle((SingleProperty<?>)this.VARIANT);
    }

    private Optional<Cow.Variant> readCowVariant(String propertyName, String string) throws ParseErrorException {
        return InputHandles.readRegistry(RegistryKey.COW_VARIANT, propertyName, string);
    }

    @Override
    @Nullable
    protected Cow tryCastEntity(@Nullable Entity targetEntity) {
        Cow cow;
        return targetEntity instanceof Cow ? (cow = (Cow)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Cow cow) {
        super.setupPropertiesFromEntity(meta, propertyHandler, cow);
        propertyHandler.set(this.VARIANT, cow.getVariant());
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        propertyHandler.set(this.VARIANT, DisguiseUtils.pick(this.VARIANT.randomValues()));
    }
}

