/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityPropertyCollection;
import xyz.nifeather.morph.utilities.DisguiseUtils;

public class HorsePropertyCollection
extends BaseLivingEntityPropertyCollection<Horse> {
    private final Map<String, Horse.Color> colorMap = new ConcurrentHashMap<String, Horse.Color>();
    private final Map<String, Horse.Style> styleMap = new ConcurrentHashMap<String, Horse.Style>();
    public final SingleProperty<Horse.Color> COLOR;
    public final SingleProperty<Horse.Style> STYLE;

    private void initMaps() {
        for (Horse.Color color : Horse.Color.values()) {
            this.colorMap.put(color.name().toLowerCase(), color);
        }
        for (Horse.Color color : Horse.Style.values()) {
            this.styleMap.put(color.name().toLowerCase(), (Horse.Style)color);
        }
    }

    private Optional<Horse.Color> readHorseColor(String propertyName, String string) throws ParseErrorException {
        return InputHandles.readEnumNonNull((Enum[])Horse.Color.values(), (String)propertyName, (String)string);
    }

    private Optional<Horse.Style> readHorseStyle(String propertyName, String string) throws ParseErrorException {
        return InputHandles.readEnumNonNull((Enum[])Horse.Style.values(), (String)propertyName, (String)string);
    }

    public HorsePropertyCollection() {
        this.initMaps();
        this.COLOR = SingleProperty.builder("horse/color", Horse.Color.WHITE).withInputHandle(this::readHorseColor).withOutputHandle(OutputHandles::writeEnum).withRandom((Horse.Color[])Horse.Color.values()).withSuggestions(this.colorMap.keySet()).build();
        this.STYLE = SingleProperty.builder("horse/style", Horse.Style.NONE).withInputHandle(this::readHorseStyle).withOutputHandle(OutputHandles::writeEnum).withRandom((Horse.Style[])Horse.Style.values()).withSuggestions(this.styleMap.keySet()).build();
        this.registerSingle(this.COLOR, this.STYLE);
    }

    @Override
    @Nullable
    protected Horse tryCastEntity(@Nullable Entity targetEntity) {
        Horse horse;
        return targetEntity instanceof Horse ? (horse = (Horse)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Horse horse) {
        super.setupPropertiesFromEntity(meta, propertyHandler, horse);
        propertyHandler.set(this.COLOR, horse.getColor());
        propertyHandler.set(this.STYLE, horse.getStyle());
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        propertyHandler.set(this.COLOR, DisguiseUtils.pick(this.COLOR.randomValues()));
        propertyHandler.set(this.STYLE, DisguiseUtils.pick(this.STYLE.randomValues()));
    }
}

