/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Pig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityPropertyCollection;
import xyz.nifeather.morph.utilities.DisguiseUtils;

public class PigPropertyCollection
extends BaseLivingEntityPropertyCollection<Pig> {
    private final Map<String, Pig.Variant> variantMap = new ConcurrentHashMap<String, Pig.Variant>();
    public final SingleProperty<Pig.Variant> VARIANT;

    public PigPropertyCollection() {
        for (Pig.Variant variant : RegistryAccess.registryAccess().getRegistry(RegistryKey.PIG_VARIANT)) {
            this.variantMap.put(variant.key().asString(), variant);
        }
        this.VARIANT = SingleProperty.builder("pig/variant", Pig.Variant.TEMPERATE).withInputHandle(this::readVariant).withOutputHandle(OutputHandles::writeKeyed).withRandom((Pig.Variant[])new Pig.Variant[]{Pig.Variant.TEMPERATE, Pig.Variant.COLD, Pig.Variant.WARM}).withSuggestions(this.variantMap.keySet()).build();
        this.registerSingle((SingleProperty<?>)this.VARIANT);
    }

    private Optional<Pig.Variant> readVariant(String propertyName, String string) throws ParseErrorException {
        return InputHandles.readRegistry(RegistryKey.PIG_VARIANT, propertyName, string);
    }

    @Override
    @Nullable
    protected Pig tryCastEntity(@Nullable Entity targetEntity) {
        Pig pig;
        return targetEntity instanceof Pig ? (pig = (Pig)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Pig targetEntity) {
        super.setupPropertiesFromEntity(meta, propertyHandler, targetEntity);
        propertyHandler.set(this.VARIANT, targetEntity.getVariant());
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        propertyHandler.set(this.VARIANT, DisguiseUtils.pick(this.VARIANT.randomValues()));
    }
}

