/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.api.FeatherMorphAPI;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;

public abstract class PropertyCollection<E extends Entity> {
    protected final Logger logger = FeatherMorphMain.getInstance().getSLF4JLogger();
    protected final Map<String, SingleProperty<?>> values = new ConcurrentHashMap();

    protected void registerSingle(SingleProperty<?> ... value) {
        for (SingleProperty<?> property : value) {
            this.registerSingle(property);
        }
    }

    protected void registerSingle(SingleProperty<?> value) {
        SingleProperty duplicateValue = this.values.getOrDefault(value.id(), null);
        if (duplicateValue != null) {
            throw new IllegalArgumentException("Already contains a value with ID '%s'".formatted(value.id()));
        }
        this.values.put(value.id(), value);
    }

    public Map<String, SingleProperty<?>> getRegisteredProperties() {
        return Map.copyOf(this.values);
    }

    @Nullable
    protected abstract E tryCastEntity(@Nullable Entity var1);

    protected boolean validateOtherDisguise(DisguiseState our, DisguiseState other) {
        if (other.getDisguiseType() == DisguiseTypes.PLAYER) {
            return our.getDisguiseType() == DisguiseTypes.PLAYER;
        }
        return other.getDisguiseIdentifier().equals(our.getDisguiseIdentifier());
    }

    public final void setupProperties(DisguiseState state, @Nullable Entity targetEntity) {
        DisguiseState theirDisguise = Objects.requireNonNull(FeatherMorphAPI.instance()).directAccess().morphManager().getDisguiseStateFor(targetEntity);
        if (theirDisguise != null) {
            if (this.validateOtherDisguise(state, theirDisguise)) {
                this.setupFromOtherDisguise(state, theirDisguise);
            }
            return;
        }
        DisguiseMeta disguiseMeta = new DisguiseMeta(state.getDisguiseIdentifier(), DisguiseTypes.fromId(state.getDisguiseIdentifier()));
        E cast = this.tryCastEntity(targetEntity);
        if (cast != null) {
            this.setupPropertiesFromEntity(disguiseMeta, state.disguisePropertyHandler(), cast);
        } else {
            this.setupDefaultProperties(state.disguisePropertyHandler());
        }
    }

    protected abstract void setupPropertiesFromEntity(DisguiseMeta var1, PropertyHandler var2, @NotNull E var3);

    protected abstract void setupDefaultProperties(PropertyHandler var1);

    protected void setupFromOtherDisguise(DisguiseState ourState, DisguiseState theirState) {
        PropertyHandler ourHandler = ourState.disguisePropertyHandler();
        PropertyHandler theirHandler = theirState.disguisePropertyHandler();
        theirHandler.copyTo(ourHandler);
    }
}

