/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Slime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityPropertyCollection;

public class SlimeMagmaPropertyCollection
extends BaseLivingEntityPropertyCollection<Slime> {
    public final SingleProperty<Integer> SIZE = SingleProperty.builder("slime_magma/size", 1).withInputHandle(this::readSize).withOutputHandle(OutputHandles::writeInteger).build();

    private Optional<Integer> readSize(String propertyName, String string) throws ParseErrorException {
        Integer val = InputHandles.readInteger(propertyName, string).orElseThrow(() -> new ParseErrorException(propertyName, "readSize: Unable to parse slime/magma size"));
        InputHandles.throwIfOutOfBounds(propertyName, val, 1, 4);
        return Optional.of(val);
    }

    public SlimeMagmaPropertyCollection() {
        this.registerSingle((SingleProperty<?>)this.SIZE);
    }

    @Override
    @Nullable
    protected Slime tryCastEntity(@Nullable Entity targetEntity) {
        Slime slime;
        return targetEntity instanceof Slime ? (slime = (Slime)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Slime targetEntity) {
        super.setupPropertiesFromEntity(meta, propertyHandler, targetEntity);
        propertyHandler.set(this.SIZE, targetEntity.getSize());
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        propertyHandler.set(this.SIZE, ThreadLocalRandom.current().nextInt(1, 5));
    }
}

