/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.integrations.placeholderapi.builtin;

import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.integrations.placeholderapi.IPlaceholderProvider;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;

public class StateNameProvider
extends MorphPluginObject
implements IPlaceholderProvider {
    @Resolved
    private MorphManager morphs;

    @Override
    @NotNull
    public String getPlaceholderIdentifier() {
        return "state";
    }

    @Override
    @Nullable
    public String resolvePlaceholder(Player player, String param) {
        String[] spilt;
        DisguiseState state = this.morphs.getDisguiseStateFor(player);
        switch (param) {
            case "id": {
                return state != null ? state.getDisguiseIdentifier() : "not_disguised";
            }
            case "name": {
                return state != null ? PlainTextComponentSerializer.plainText().serialize(state.getServerDisplay()) : "not_disguised";
            }
            case "status": {
                return state != null ? "true" : "false";
            }
        }
        if (param.startsWith("provider_is")) {
            spilt = param.split("\\?", 2);
            if (spilt.length < 2) {
                return "invalid_provider_param";
            }
            String namespace = spilt[1];
            return state != null ? (namespace.equals(state.getProvider().getNameSpace()) ? "true" : "false") : "false";
        }
        if (param.startsWith("id_is")) {
            spilt = param.split("\\?", 2);
            if (spilt.length < 2) {
                return "invalid_id_param";
            }
            return state != null ? (state.getDisguiseIdentifier().equals(spilt[1]) ? "true" : "false") : "false";
        }
        return "invalid_param";
    }
}

