/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.mobs.goal.handles.impl;

import java.util.Collection;
import java.util.Optional;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import xyz.nifeather.morph.misc.mobs.goal.AvoidPlayerGoals;
import xyz.nifeather.morph.misc.mobs.goal.handles.impl.BasicEntityHandle;
import xyz.nifeather.morph.misc.mobs.goal.impl.MorphNearestAttackableGoal;

public class CatHandle
extends BasicEntityHandle<Cat> {
    @Override
    public Optional<Cat> tryCast(Entity entity) {
        Cat cat;
        return Optional.ofNullable(entity instanceof Cat ? (cat = (Cat)entity) : null);
    }

    @Override
    protected Collection<WrappedGoal> filterGoals(Cat mob) {
        return this.goalSelector(mob).getAvailableGoals().stream().filter(wrappedGoal -> wrappedGoal.getGoal().getClass().getSimpleName().equals("CatAvoidEntityGoal")).toList();
    }

    @Override
    protected void onTargetGoalFound(Cat cat, WrappedGoal vanillaGoal) {
        Goal replacingGoal = AvoidPlayerGoals.findGoal(cat, this.morphManager(), this.revealingHandler(), 16.0, 0.8, 1.33);
        if (replacingGoal == null) {
            return;
        }
        GoalSelector selector = this.goalSelector(cat);
        selector.removeGoal(vanillaGoal.getGoal());
        selector.addGoal(vanillaGoal.getPriority(), replacingGoal);
    }

    @Override
    protected void addDefaultGoals(Cat mob) {
        MorphNearestAttackableGoal goal = new MorphNearestAttackableGoal((Mob)mob, this.morphManager());
        this.goalSelector(mob).addGoal(1, (Goal)goal);
    }
}

