/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.waypoint.connection;

import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTrackedWaypointPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.waypoints.Waypoint;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.NmsRecord;

public class MorphChunkConnection
implements WaypointTransmitter.Connection {
    private final DisguiseState bindingState;
    private final Waypoint.Icon icon;
    private final ServerPlayer receiver;
    private final Player receiverBukkit;
    private ChunkPos lastPosition;

    public MorphChunkConnection(DisguiseState state, Waypoint.Icon icon, ServerPlayer receiver) {
        this.bindingState = state;
        this.icon = icon;
        this.receiver = receiver;
        this.receiverBukkit = receiver.getBukkitEntity();
        this.lastPosition = NmsRecord.ofPlayer(state.getPlayer()).chunkPosition();
    }

    public void connect() {
        UUID uuid = this.bindingState.getDisguiseWrapper().getVirtualEntityUUID();
        ServerPlayer player = NmsRecord.ofPlayer(this.bindingState.getPlayer());
        this.receiver.connection.send((Packet)ClientboundTrackedWaypointPacket.addWaypointChunk((UUID)uuid, (Waypoint.Icon)this.icon, (ChunkPos)player.chunkPosition()));
    }

    public void disconnect() {
        UUID uuid = this.bindingState.getDisguiseWrapper().getVirtualEntityUUID();
        this.receiver.connection.send((Packet)ClientboundTrackedWaypointPacket.removeWaypoint((UUID)uuid));
    }

    public void update() {
        ServerPlayer source = NmsRecord.ofPlayer(this.bindingState.getPlayer());
        ChunkPos chunkPos = source.chunkPosition();
        if (chunkPos.getChessboardDistance(this.lastPosition) <= 0) {
            return;
        }
        UUID uuid = this.bindingState.getDisguiseWrapper().getVirtualEntityUUID();
        this.receiver.connection.send((Packet)ClientboundTrackedWaypointPacket.updateWaypointChunk((UUID)uuid, (Waypoint.Icon)this.icon, (ChunkPos)chunkPos));
        this.lastPosition = chunkPos;
    }

    public boolean isBroken() {
        ServerPlayer player = NmsRecord.ofPlayer(this.bindingState.getPlayer());
        return !WaypointTransmitter.isChunkVisible((ChunkPos)player.chunkPosition(), (ServerPlayer)this.receiver) || WaypointTransmitter.isReallyFar((LivingEntity)player, (ServerPlayer)this.receiver) || this.bindingState.getPlayer().isTrackedBy(this.receiverBukkit);
    }
}

