/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.multiInstance.protocol.c2s;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import xyz.nifeather.morph.network.multiInstance.protocol.IInstanceClientHandler;
import xyz.nifeather.morph.network.multiInstance.protocol.c2s.MIC2SCommand;
import xyz.nifeather.morph.network.utils.Asserts;

public class MIC2SRequestSyncCommand
extends MIC2SCommand {
    public final List<UUID> requestedUUIDs;

    public MIC2SRequestSyncCommand(List<UUID> requestedUUIDs) {
        super("request_meta_sync");
        this.requestedUUIDs = ImmutableList.copyOf(requestedUUIDs);
    }

    @Override
    public Map<String, String> generateArgumentMap() {
        return Map.of("requested_uuids", MIC2SRequestSyncCommand.gson().toJson(this.requestedUUIDs));
    }

    public static MIC2SRequestSyncCommand fromArguments(Map<String, String> argument) {
        ObjectArrayList uuids = new ObjectArrayList();
        if (argument.containsKey("requested_uuids")) {
            List<UUID> list = Asserts.getStringListOrThrow(argument, "requested_uuids").stream().map(UUID::fromString).toList();
            uuids.addAll(list);
        }
        return new MIC2SRequestSyncCommand((List<UUID>)uuids);
    }

    @Override
    public void onCommand(IInstanceClientHandler handler) {
        handler.onSlaveRequestMetaSync(this);
    }
}

