/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.multiInstance.slave;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.interfaces.IManagePlayerData;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.network.multiInstance.protocol.Operation;
import xyz.nifeather.morph.network.multiInstance.protocol.c2s.MIC2SSyncDisguiseCommand;
import xyz.nifeather.morph.network.multiInstance.slave.SlaveInstance;
import xyz.nifeather.morph.shaded.pluginbase.Exceptions.NullDependencyException;
import xyz.nifeather.morph.storage.playerdata.PlayerMeta;

public class NetworkDataHolder
extends MorphPluginObject
implements IManagePlayerData {
    private final Map<UUID, PlayerMeta> localMetaMap = new ConcurrentHashMap<UUID, PlayerMeta>();
    private final SlaveInstance bindingSlave;
    private final Map<String, DisguiseMeta> cachedMetas = new ConcurrentHashMap<String, DisguiseMeta>();

    public NetworkDataHolder(SlaveInstance bindingSlave) {
        this.bindingSlave = bindingSlave;
    }

    @Override
    @Nullable
    public DisguiseMeta getDisguiseMeta(String rawString) {
        DisguiseMeta cached = this.cachedMetas.getOrDefault(rawString, null);
        if (cached != null) {
            return cached;
        }
        DisguiseTypes type = DisguiseTypes.fromId(rawString);
        DisguiseMeta meta = new DisguiseMeta(rawString, type);
        this.cachedMetas.put(rawString, meta);
        return meta;
    }

    @Override
    public List<DisguiseMeta> getAvailableDisguisesFor(Player player) {
        PlayerMeta playerMeta = this.getPlayerMeta((OfflinePlayer)player);
        return playerMeta.getUnlockedDisguises();
    }

    @Override
    public CompletableFuture<PlayerMeta> loadPlayerDataAsync(UUID uuid) {
        CompletableFuture<PlayerMeta> future = new CompletableFuture<PlayerMeta>();
        this.bindingSlave.requestData(uuid).thenAccept(u -> {
            PlayerMeta data = this.nullablePlayerMeta(Bukkit.getOfflinePlayer((UUID)u));
            if (data != null) {
                future.complete(data);
            } else {
                future.completeExceptionally(new NullDependencyException("The future of the requested data has been finished, but we can't find a matching data in NetworkDataHolder!"));
            }
        });
        return future;
    }

    @Override
    public boolean grantMorphToPlayer(Player player, String disguiseIdentifier) {
        if (!this.bindingSlave.isOnline()) {
            this.logger.error("We are not connected with master server! Refusing to update unlock state...");
            return false;
        }
        PlayerMeta meta = this.nullablePlayerMeta((OfflinePlayer)player);
        if (meta == null) {
            return false;
        }
        if (meta.getUnlockedDisguiseIdentifiers().stream().anyMatch(str -> str.equals(disguiseIdentifier))) {
            return false;
        }
        this.bindingSlave.sendCommand(new MIC2SSyncDisguiseCommand(Operation.ADD_IF_ABSENT, List.of(disguiseIdentifier), player.getUniqueId()));
        return true;
    }

    @Override
    public boolean revokeMorphFromPlayer(Player player, String disguiseIdentifier) {
        if (!this.bindingSlave.isOnline()) {
            this.logger.error("We are not connected with master server! Refusing to update unlock state...");
            return false;
        }
        PlayerMeta meta = this.nullablePlayerMeta((OfflinePlayer)player);
        if (meta == null) {
            return false;
        }
        if (meta.getUnlockedDisguiseIdentifiers().stream().noneMatch(str -> str.equals(disguiseIdentifier))) {
            return false;
        }
        this.bindingSlave.sendCommand(new MIC2SSyncDisguiseCommand(Operation.REMOVE, List.of(disguiseIdentifier), player.getUniqueId()));
        return true;
    }

    @Nullable
    public PlayerMeta nullablePlayerMeta(OfflinePlayer player) {
        return this.localMetaMap.getOrDefault(player.getUniqueId(), null);
    }

    @NotNull
    public PlayerMeta getOrCreatePlayerMeta(OfflinePlayer player) {
        PlayerMeta tracked = this.nullablePlayerMeta(player);
        if (tracked != null) {
            return tracked;
        }
        PlayerMeta metaInstance = new PlayerMeta();
        metaInstance.uniqueId = player.getUniqueId();
        metaInstance.playerName = player.getName();
        this.localMetaMap.put(player.getUniqueId(), metaInstance);
        return metaInstance;
    }

    @Override
    @NotNull
    public PlayerMeta getPlayerMeta(OfflinePlayer player) {
        PlayerMeta tracked = this.nullablePlayerMeta(player);
        if (tracked != null) {
            return tracked;
        }
        PlayerMeta tempInstance = new PlayerMeta();
        tempInstance.uniqueId = player.getUniqueId();
        tempInstance.playerName = player.getName();
        return tempInstance;
    }

    @Override
    public boolean reload() {
        this.dropAll();
        List<UUID> players = ImmutableList.copyOf((Collection)Bukkit.getOnlinePlayers()).stream().map(OfflinePlayer::getUniqueId).toList();
        this.bindingSlave.requestData(players);
        return true;
    }

    public void dropAll() {
        this.logger.info("[Slave@NetworkData] Dropping cached network player meta...");
        this.localMetaMap.clear();
    }

    @Override
    public boolean save() {
        return true;
    }

    @Override
    public List<PlayerMeta> getRange(List<UUID> list) {
        ObjectArrayList metaList = new ObjectArrayList();
        list.forEach(arg_0 -> this.lambda$getRange$3((List)metaList, arg_0));
        return metaList;
    }

    private /* synthetic */ void lambda$getRange$3(List metaList, UUID uuid) {
        PlayerMeta existing = this.localMetaMap.getOrDefault(uuid, null);
        if (existing != null) {
            metaList.add(existing);
        }
    }
}

