/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.server;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.network.commands.C2S.ClientInitializeRecordV3;
import xyz.nifeather.morph.network.server.MessageChannel;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.network.server.handlers.V1ProtocolHandler;
import xyz.nifeather.morph.network.server.handlers.V2ProtocolHandler;
import xyz.nifeather.morph.network.server.handlers.results.VersionHandleResult;

public class LegacyClientHandler
extends MorphPluginObject {
    private final MorphClientHandler clientHandler;

    public LegacyClientHandler(MorphClientHandler clientHandler) {
        this.clientHandler = clientHandler;
        Messenger messenger = Bukkit.getMessenger();
        messenger.registerIncomingPluginChannel((Plugin)this.plugin, MessageChannel.versionChannelV2, this::handleVersionV2);
        messenger.registerOutgoingPluginChannel((Plugin)this.plugin, MessageChannel.versionChannelV2);
        messenger.registerIncomingPluginChannel((Plugin)this.plugin, MessageChannel.commandChannelV2, this::handleCommandV2);
        messenger.registerOutgoingPluginChannel((Plugin)this.plugin, MessageChannel.commandChannelV2);
        messenger.registerIncomingPluginChannel((Plugin)this.plugin, MessageChannel.initializeChannelV1, this::handleInitializeV1V2);
        messenger.registerOutgoingPluginChannel((Plugin)this.plugin, MessageChannel.initializeChannelV1);
        messenger.registerIncomingPluginChannel((Plugin)this.plugin, MessageChannel.versionChannelV1, this::handleVersionV1);
        messenger.registerOutgoingPluginChannel((Plugin)this.plugin, MessageChannel.versionChannelV1);
        messenger.registerIncomingPluginChannel((Plugin)this.plugin, MessageChannel.commandChannelV1, this::handleCommandV1);
        messenger.registerOutgoingPluginChannel((Plugin)this.plugin, MessageChannel.commandChannelV1);
    }

    private void handleInitializeV1V2(@NotNull String cN, @NotNull Player player, byte @NotNull [] bytes) {
        MorphClientHandler.logPacket(false, player, cN, bytes);
        if (this.clientHandler.getProtocolHandler(player) != null) {
            if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
                this.logger.info("Received init message on legacy channel while '%s' have a ProtocolHandler, ignoring...".formatted(player.getName()));
            }
            return;
        }
        ClientInitializeRecordV3 v2Handle = V2ProtocolHandler.V2_INSTANCE.handleInitializeData(player, bytes);
        if (v2Handle.handleSuccess()) {
            this.clientHandler.setProtocolHandlerFor(player, V2ProtocolHandler.V2_INSTANCE);
            this.logger.info("%s is using V2 packets, scheduling response".formatted(player.getName()));
            this.clientHandler.getPlayerChannelPendingFuture(player).thenRun(() -> V2ProtocolHandler.V2_INSTANCE.sendV2InitalizeRespond(player, this.clientHandler.getInitializeRespond().serverFeatures()));
            return;
        }
        this.clientHandler.setProtocolHandlerFor(player, V1ProtocolHandler.V1_INSTANCE);
        this.logger.info("%s is using V1 packets, scheduling response".formatted(player.getName()));
        this.clientHandler.getPlayerChannelPendingFuture(player).thenRun(() -> V1ProtocolHandler.V1_INSTANCE.sendV1InitializeRespond(player));
    }

    private void handleCommandV2(@NotNull String channelName, @NotNull Player player, byte @NotNull [] bytes) {
        this.clientHandler.handleCommandFromHandlerInternal(V2ProtocolHandler.V2_INSTANCE, channelName, player, bytes);
    }

    private void handleCommandV1(@NotNull String channelName, @NotNull Player player, byte @NotNull [] bytes) {
        this.clientHandler.handleCommandFromHandlerInternal(V1ProtocolHandler.V1_INSTANCE, channelName, player, bytes);
    }

    private void handleVersionV1(@NotNull String cN, @NotNull Player player, byte @NotNull [] data) {
        MorphClientHandler.logPacket(false, player, cN, data);
        V1ProtocolHandler protocolHandler = V1ProtocolHandler.V1_INSTANCE;
        VersionHandleResult handleResult = protocolHandler.handleVersionData(player, data);
        if (!handleResult.success()) {
            this.clientHandler.rejectPlayer(player);
            return;
        }
        ClientInitializeRecordV3 client = new ClientInitializeRecordV3(List.of(), handleResult.result(), true);
        this.clientHandler.handleHandshakeMessage(protocolHandler, player, client);
    }

    private void handleVersionV2(@NotNull String cN, @NotNull Player player, byte @NotNull [] data) {
        MorphClientHandler.logPacket(false, player, cN, data);
        V2ProtocolHandler protocolHandler = V2ProtocolHandler.V2_INSTANCE;
        VersionHandleResult handleResult = protocolHandler.handleVersionData(player, data);
        if (!handleResult.success()) {
            this.clientHandler.rejectPlayer(player);
            return;
        }
        ClientInitializeRecordV3 client = new ClientInitializeRecordV3(List.of(), handleResult.result(), true);
        this.clientHandler.handleHandshakeMessage(protocolHandler, player, client);
    }
}

