/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.providers.disguise;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.backends.DisguiseBackend;
import xyz.nifeather.morph.backends.DisguiseWrapper;
import xyz.nifeather.morph.config.ConfigOptions;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.strings.MorphStrings;
import xyz.nifeather.morph.messages.vanilla.MasterVanillaMessageStore;
import xyz.nifeather.morph.misc.BoundingBoxLookup;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.misc.NmsRecord;
import xyz.nifeather.morph.providers.animation.AnimationProvider;
import xyz.nifeather.morph.providers.animation.provider.VanillaAnimationProvider;
import xyz.nifeather.morph.providers.disguise.DefaultDisguiseProvider;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.utilities.CollisionUtils;
import xyz.nifeather.morph.utilities.EntityTypeUtils;
import xyz.nifeather.morph.utilities.NmsUtils;
import xyz.nifeather.morph.utilities.ReflectionUtils;

public class VanillaDisguiseProvider
extends DefaultDisguiseProvider {
    private final AnimationProvider animationProvider = new VanillaAnimationProvider();
    private final Bindable<Boolean> armorStandShowArms = new Bindable<Boolean>(false);
    private final Bindable<Boolean> doHealthScale = new Bindable<Boolean>(false);
    private final Bindable<Integer> healthCap = new Bindable<Integer>(60);
    private final Bindable<Boolean> modifyBoundingBoxes = new Bindable<Boolean>(false);
    private final Bindable<Boolean> checkSpaceBoundingBox = new Bindable<Boolean>(true);
    private final List<String> vanillaIdentifiers;
    @NotNull
    public static final NamespacedKey healthModifierKeyLegacy = Objects.requireNonNull(NamespacedKey.fromString((String)"feathermorph:health_modifier"), "How?!");
    @NotNull
    public static final NamespacedKey healthModifierKey = Objects.requireNonNull(NamespacedKey.fromString((String)"feathermorph:fm_health_modifier"), "How?!");
    @Resolved
    private MasterVanillaMessageStore masterVanillaMessageStore;

    @Override
    @NotNull
    public String getNameSpace() {
        return DisguiseTypes.VANILLA.getNameSpace();
    }

    @Override
    public AnimationProvider getAnimationProvider() {
        return this.animationProvider;
    }

    @Override
    public boolean isValid(String rawIdentifier) {
        String idStripped = DisguiseTypes.VANILLA.toStrippedId(rawIdentifier);
        return this.getAllAvailableDisguises().contains(idStripped);
    }

    public VanillaDisguiseProvider() {
        ObjectArrayList list = new ObjectArrayList();
        for (EntityType eT : EntityType.values()) {
            if (eT == EntityType.UNKNOWN || !eT.isAlive()) continue;
            list.add((Object)eT.getKey().getKey());
        }
        list.removeIf(s -> s.equals("player"));
        this.vanillaIdentifiers = list;
    }

    @Initializer
    private void load(MorphConfigManager configManager) {
        configManager.bind(this.armorStandShowArms, ConfigOptions.ARMORSTAND_SHOW_ARMS);
        configManager.bind(this.doHealthScale, ConfigOptions.HEALTH_SCALE);
        configManager.bind(this.healthCap, ConfigOptions.HEALTH_SCALE_MAX_HEALTH);
        configManager.bind(this.modifyBoundingBoxes, ConfigOptions.MODIFY_BOUNDING_BOX);
        configManager.bind(this.checkSpaceBoundingBox, ConfigOptions.CHECK_AVAILABLE_SPACE);
        this.modifyBoundingBoxes.onValueChanged((o, n) -> {
            if (o.booleanValue() && !n.booleanValue()) {
                this.featherMorph().getPlatform().onlinePlayersNative().forEach(p -> NmsRecord.ofPlayer(p).refreshDimensions());
            }
        });
    }

    @Override
    public List<String> getAllAvailableDisguises() {
        return this.vanillaIdentifiers;
    }

    @Override
    public boolean validateDisguise(Player player, DisguiseMeta disguiseMeta, Entity targetEntity) {
        EntityType entityType = disguiseMeta.getEntityType();
        if (this.modifyBoundingBoxes.get().booleanValue() && this.checkSpaceBoundingBox.get().booleanValue()) {
            BoundingBox box = BoundingBoxLookup.instance().getBoundingBoxAt(disguiseMeta.getEntityType(), player.getLocation());
            boolean hasCollision = CollisionUtils.hasHardCollision(player.getWorld(), box);
            if (hasCollision) {
                MessageUtils.send((CommandSender)player, MorphStrings.noEnoughSpaceString());
                return false;
            }
        }
        if (entityType == null || entityType == EntityType.PLAYER || !entityType.isAlive()) {
            MessageUtils.send((CommandSender)player, MorphStrings.disguiseBannedOrNotSupportedString());
            this.logger.error("Can't disguise player %s because someone is trying to use an illegal mob type: %s(%s)".formatted(player.getName(), disguiseMeta.getIdentifier(), entityType));
            return false;
        }
        return super.validateDisguise(player, disguiseMeta, targetEntity);
    }

    @Override
    @NotNull
    public Optional<DisguiseWrapper<?>> makeWrapper(Player player, DisguiseMeta disguiseMeta, @Nullable Entity targetEntity) {
        DisguiseBackend<?, ?> backend = this.getPreferredBackend();
        return Optional.ofNullable(backend.createInstance(disguiseMeta.getEntityType()));
    }

    @Override
    public boolean updateDisguise(Player player, DisguiseState state) {
        if (super.updateDisguise(player, state)) {
            if (this.modifyBoundingBoxes.get().booleanValue()) {
                this.tryModifyPlayerDimensions(player, state.getDisguiseWrapper());
            }
            if (this.plugin.getCurrentTick() % 20L == 0L) {
                ReflectionUtils.cleanCaches();
            }
            return true;
        }
        return false;
    }

    private void tryAddModifier(DisguiseState state) {
        try {
            Player player = state.getPlayer();
            Location loc = player.getLocation();
            loc.setY(-8192.0);
            Entity entity = NmsUtils.spawnEntity(state.getEntityType(), state.getPlayer().getWorld(), loc);
            if (!(entity instanceof org.bukkit.entity.LivingEntity)) {
                entity.remove();
                return;
            }
            org.bukkit.entity.LivingEntity living = (org.bukkit.entity.LivingEntity)entity;
            LivingEntity craftLiving = (LivingEntity)((CraftLivingEntity)living).getHandleRaw();
            double mobMaxHealth = Objects.requireNonNull(craftLiving.craftAttributes.getAttribute(Attribute.MAX_HEALTH), "Bad server implementation").getBaseValue();
            if (state.getEntityType() == EntityType.CREAKING) {
                mobMaxHealth = 20.0;
            }
            AttributeInstance playerAttribute = player.getAttribute(Attribute.MAX_HEALTH);
            if (mobMaxHealth <= 0.0) {
                this.logger.warn("Entity has a max health that's lower than 0? Not applying...");
                return;
            }
            assert (playerAttribute != null);
            double diff = mobMaxHealth - playerAttribute.getBaseValue();
            if (playerAttribute.getBaseValue() + diff > (double)this.healthCap.get().intValue()) {
                diff = (double)this.healthCap.get().intValue() - playerAttribute.getBaseValue();
            }
            double diffFinal = diff;
            playerAttribute.removeModifier((Key)healthModifierKey);
            playerAttribute.removeModifier((Key)healthModifierKeyLegacy);
            AttributeModifier modifier = new AttributeModifier(healthModifierKey, diffFinal, AttributeModifier.Operation.ADD_NUMBER);
            this.runThenScaleHealth(player, playerAttribute, () -> playerAttribute.addTransientModifier(modifier));
            entity.remove();
        }
        catch (Throwable t) {
            this.logger.error("Error occurred trying to modify player's health attribute", t);
        }
    }

    private void resetPlayerDimensions(Player player) {
        ServerPlayer nmsPlayer = NmsRecord.ofPlayer(player);
        Field targetField = null;
        try {
            targetField = ReflectionUtils.getPlayerDimensionsField(nmsPlayer);
        }
        catch (Throwable t) {
            this.logger.error("Can't read player dimension.", t);
        }
        if (targetField == null) {
            return;
        }
        try {
            EntityDimensions dimension = EntityDimensions.scalable((float)0.6f, (float)1.8f).withEyeHeight(1.62f);
            targetField.setAccessible(true);
            targetField.set(nmsPlayer, dimension);
            nmsPlayer.refreshDimensions();
        }
        catch (Throwable t) {
            this.logger.error("Unable to reset player's bounding box", t);
        }
    }

    private void tryModifyPlayerDimensions(Player player, DisguiseWrapper<?> wrapper) {
        ServerPlayer nmsPlayer = NmsRecord.ofPlayer(player);
        Field targetField = null;
        try {
            targetField = ReflectionUtils.getPlayerDimensionsField(nmsPlayer);
        }
        catch (Throwable t) {
            this.logger.error("Can't read player dimension.", t);
        }
        if (targetField == null) {
            return;
        }
        try {
            BoundingBox box = BoundingBoxLookup.instance().getBoundingBoxAt(wrapper.getEntityType(), player.getLocation());
            EntityDimensions dimensions = EntityDimensions.fixed((float)((float)box.getWidthX()), (float)((float)box.getHeight()));
            Vector center = player.getBoundingBox().getCenter();
            AABB aabb = AABB.ofSize((Vec3)new Vec3(center.getX(), center.getY(), center.getZ()), (double)box.getWidthX(), (double)box.getHeight(), (double)box.getWidthZ());
            targetField.set(nmsPlayer, dimensions);
            nmsPlayer.setBoundingBox(aabb);
            Field eyeHeightField = ReflectionUtils.getPlayerEyeHeightField(NmsRecord.ofPlayer(player));
            eyeHeightField.set(nmsPlayer, Float.valueOf(dimensions.height() * 0.85f));
        }
        catch (Throwable t) {
            this.logger.warn("Unable to modify player's bounding box", t);
        }
    }

    private void runThenScaleHealth(Player player, AttributeInstance attributeInstance, Runnable runnable) {
        double currentPercent = player.getHealth() / attributeInstance.getValue();
        try {
            runnable.run();
        }
        catch (Throwable t) {
            this.logger.warn("Failed to execute Runnable in VanillaDisguiseProvider#runThenScaleHealth", t);
        }
        if (player.getHealth() > 0.0) {
            player.setHealth(Math.min(player.getMaxHealth(), attributeInstance.getValue() * currentPercent));
        }
    }

    @Override
    public void onPlayerJoinWithDisguise(DisguiseState state) {
        this.onDisguiseApply(state);
        this.mutePlayerWaypoint(state.getPlayer());
        super.onPlayerJoinWithDisguise(state);
    }

    private void removeAllHealthModifiers(Player player) {
        AttributeInstance attribute = player.getAttribute(Attribute.MAX_HEALTH);
        assert (attribute != null);
        this.runThenScaleHealth(player, attribute, () -> attribute.removeModifier((Key)healthModifierKey));
    }

    @Override
    public boolean unMorph(Player player, DisguiseState state) {
        if (super.unMorph(player, state)) {
            this.removeAllHealthModifiers(player);
            this.resetPlayerDimensions(player);
            this.recoverPlayerWaypoint(player);
            return true;
        }
        return false;
    }

    @Override
    public void onDisguiseApply(DisguiseState state) {
        super.onDisguiseApply(state);
        Player player = state.getPlayer();
        if (this.doHealthScale.get().booleanValue()) {
            this.tryAddModifier(state);
        }
        if (this.modifyBoundingBoxes.get().booleanValue()) {
            this.tryModifyPlayerDimensions(player, state.getDisguiseWrapper());
        }
        this.mutePlayerWaypoint(player);
    }

    @Override
    public boolean validForClient(DisguiseState state) {
        return true;
    }

    @Override
    public boolean canCloneEquipment(DisguiseMeta info, Entity targetEntity, DisguiseState theirState) {
        return theirState != null ? theirState.getDisguiseWrapper().getEntityType().equals((Object)info.getEntityType()) : targetEntity == null || targetEntity.getType().equals((Object)info.getEntityType());
    }

    @Override
    public Component getDisplayName(String disguiseIdentifier, String locale) {
        EntityType type = EntityTypeUtils.fromString(disguiseIdentifier, true);
        if (type == null) {
            return Component.text((String)"???");
        }
        return this.masterVanillaMessageStore.getComponent(type.translationKey(), null, locale);
    }
}

