/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.storage.skill;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.abilities.IAbility;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.api.morphs.skills.SkillNames;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.skills.ISkill;
import xyz.nifeather.morph.storage.skill.ISkillAbilityOption;

public class SkillAbilityConfigContainer {
    @Expose(serialize=false)
    @SerializedName(value="mobId")
    @Nullable
    public String legacy_MobID;
    @Expose
    @SerializedName(value="skillCooldown")
    private int skillCooldown;
    @Expose
    @SerializedName(value="skillId")
    private String rawSkillidentifier;
    @Expose(deserialize=false, serialize=false)
    private NamespacedKey skillIdentifier;
    @Expose
    @SerializedName(value="abilities")
    private final List<String> abilitiyIdentifiers = new CopyOnWriteArrayList<String>();
    @Expose
    @SerializedName(value="settings")
    @NotNull
    private final Map<String, Map<String, Object>> options = new ConcurrentHashMap<String, Map<String, Object>>();

    public SkillAbilityConfigContainer() {
    }

    public SkillAbilityConfigContainer(int skillCooldown, NamespacedKey skillIdentifier) {
        this.skillCooldown = skillCooldown;
        this.setSkillIdentifier(skillIdentifier);
    }

    public int getSkillCooldown() {
        return this.skillCooldown;
    }

    public SkillAbilityConfigContainer setSkillCooldown(int newCd) {
        this.skillCooldown = newCd;
        return this;
    }

    @NotNull
    public NamespacedKey getSkillIdentifier() {
        if (this.skillIdentifier == null) {
            NamespacedKey k = this.rawSkillidentifier == null ? SkillNames.NONE : NamespacedKey.fromString((String)this.rawSkillidentifier);
            this.skillIdentifier = k == null ? SkillNames.UNKNOWN : k;
        }
        return this.skillIdentifier;
    }

    public SkillAbilityConfigContainer setSkillIdentifier(NamespacedKey key) {
        this.skillIdentifier = key;
        this.rawSkillidentifier = key.asString();
        return this;
    }

    public List<String> getAbilitiyIdentifiers() {
        return this.abilitiyIdentifiers;
    }

    private SkillAbilityConfigContainer setAbilities(List<String> identifiers) {
        this.abilitiyIdentifiers.clear();
        if (identifiers != null) {
            this.abilitiyIdentifiers.addAll(identifiers);
        }
        return this;
    }

    public SkillAbilityConfigContainer addAbility(NamespacedKey id) {
        String idString = id.asString();
        if (this.abilitiyIdentifiers.stream().anyMatch(s -> s.equals(idString))) {
            return this;
        }
        this.abilitiyIdentifiers.add(idString);
        return this;
    }

    @NotNull
    public Map<String, Object> getSkillOptions(ISkill<?> skill) {
        if (skill == null) {
            return Map.of();
        }
        return this.options.getOrDefault(skill.getIdentifier().asString(), Map.of());
    }

    public <T extends ISkillAbilityOption> T readOptions(NamespacedKey abilityIdentifier, ISkillAbilityOptionHandler<T> optionHandler) throws ParseErrorException, NullPointerException {
        Map gsonMap = this.options.getOrDefault(abilityIdentifier.asString(), null);
        if (optionHandler.acceptNullableOptions()) {
            return optionHandler.readOptionNullable(gsonMap);
        }
        if (gsonMap == null) {
            throw new NullPointerException("Null option map for ability '%s'".formatted(abilityIdentifier));
        }
        return optionHandler.readOption(gsonMap);
    }

    @Nullable
    public <T extends ISkillAbilityOption> T readOptions(@Nullable IAbility<T> ability) throws ParseErrorException, NullPointerException {
        if (ability == null) {
            return null;
        }
        return this.readOptions(ability.getIdentifier(), ability.optionHandler());
    }

    public <T extends ISkillAbilityOption> T readOptions(@Nullable ISkill<T> skill) throws ParseErrorException, NullPointerException {
        if (skill == null) {
            return null;
        }
        return this.readOptions(skill.getIdentifier(), skill.optionHandler());
    }

    public <O extends ISkillAbilityOption> SkillAbilityConfigContainer setOption(NamespacedKey identifier, ISkillAbilityOptionHandler<O> optionHandler, O option) {
        ConcurrentHashMap currentOptionMap = this.options.getOrDefault(identifier.asString(), null);
        if (currentOptionMap == null) {
            ConcurrentHashMap newMap = new ConcurrentHashMap();
            this.options.put(identifier.asString(), newMap);
            currentOptionMap = newMap;
        }
        Object2ObjectOpenHashMap optionMap = new Object2ObjectOpenHashMap();
        optionHandler.writeOption(option, (Map<String, Object>)optionMap);
        currentOptionMap.clear();
        currentOptionMap.putAll(optionMap);
        return this;
    }

    public <O extends ISkillAbilityOption> SkillAbilityConfigContainer appendOption(NamespacedKey identifier, ISkillAbilityOptionHandler<O> optionHandler, O option) {
        ConcurrentHashMap currentOptionMap = this.options.getOrDefault(identifier.asString(), null);
        if (currentOptionMap == null) {
            ConcurrentHashMap newMap = new ConcurrentHashMap();
            this.options.put(identifier.asString(), newMap);
            currentOptionMap = newMap;
        }
        Object2ObjectOpenHashMap optionMap = new Object2ObjectOpenHashMap();
        optionHandler.writeOption(option, (Map<String, Object>)optionMap);
        optionMap.forEach(currentOptionMap::putIfAbsent);
        return this;
    }
}

