/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph;

import io.papermc.paper.datapack.DatapackRegistrar;
import io.papermc.paper.datapack.DiscoveredDatapack;
import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.bootstrap.PluginBootstrap;
import io.papermc.paper.plugin.bootstrap.PluginProviderContext;
import io.papermc.paper.plugin.lifecycle.event.registrar.RegistrarEvent;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.nifeather.morph.BuiltinDatapackNames;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.shaded.pluginbase.Exceptions.NullDependencyException;

public class FeatherMorphBootstrap
implements PluginBootstrap {
    private final Logger logger = LoggerFactory.getLogger((String)"FeatherMorph - Bootstrap");
    public boolean bootstrapLoaded = false;
    static final AtomicBoolean pluginDisabled = new AtomicBoolean(false);

    public void bootstrap(@NotNull BootstrapContext context) {
        this.logger.info("Loading bootstrap...");
        context.getLifecycleManager().registerEventHandler(LifecycleEvents.DATAPACK_DISCOVERY.newHandler(this::onDatapackDiscovery));
        this.bootstrapLoaded = true;
        this.logger.info("Done!");
    }

    private void onDatapackDiscovery(RegistrarEvent<DatapackRegistrar> event) {
        try {
            for (String datapack : BuiltinDatapackNames.values()) {
                this.registerBuiltinDatapack(event, datapack);
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException("Unable to register built-in datapack", e);
        }
    }

    private void registerBuiltinDatapack(RegistrarEvent<DatapackRegistrar> event, String id) throws IOException, URISyntaxException, NullDependencyException {
        URI datapackURI = Objects.requireNonNull(this.getClass().getResource("/datapacks/%s".formatted(id))).toURI();
        DiscoveredDatapack discoverResult = ((DatapackRegistrar)event.registrar()).discoverPack(datapackURI, id);
        if (discoverResult == null) {
            throw new NullDependencyException("Failed to discover recipe datapack!");
        }
        this.logger.info("Successfully registered datapack {}!", (Object)id);
    }

    @NotNull
    public JavaPlugin createPlugin(@NotNull PluginProviderContext context) {
        this.logger.info("Creating FeatherMorphMain...");
        return new FeatherMorphMain();
    }
}

