/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.abilities.impl.onAttack;

import java.util.Optional;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.abilities.impl.OnAttackAbility;
import xyz.nifeather.morph.abilities.options.ExtraKnockbackOption;
import xyz.nifeather.morph.api.morphs.abilities.AbilityNames;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;

public class ExtraKnockbackAbility
extends OnAttackAbility<ExtraKnockbackOption> {
    @Resolved(shouldSolveImmediately=true)
    private MorphManager manager;
    private static final ExtraKnockbackOption defaultOption = ExtraKnockbackOption.from(0.0, 0.4, 0.0);

    @Override
    @NotNull
    public ISkillAbilityOptionHandler<ExtraKnockbackOption> optionHandler() {
        return ExtraKnockbackOption.OPTION_HANDLER;
    }

    @Override
    @NotNull
    public NamespacedKey getIdentifier() {
        return AbilityNames.EXTRA_KNOCKBACK;
    }

    @Override
    protected void onAttack(LivingEntity damaged, Player player) {
        DisguiseState state = this.manager.getDisguiseStateFor(player);
        assert (state != null);
        ExtraKnockbackOption option = (ExtraKnockbackOption)this.getOptionFor(state);
        if (option == null) {
            option = defaultOption;
        }
        double knockbackResistance = Optional.ofNullable(damaged.getAttribute(Attribute.KNOCKBACK_RESISTANCE)).map(AttributeInstance::getValue).orElse(0.0);
        double knockMultiplier = Math.max(0.0, 1.0 - knockbackResistance);
        double yDelta = option.yMotion * knockMultiplier;
        double xDelta = option.xMotion * knockMultiplier;
        double zDelta = option.zMotion * knockMultiplier;
        Vector movement = damaged.getVelocity().clone().add(new Vector(xDelta, yDelta, zDelta));
        damaged.teleportAsync(damaged.getLocation().clone().add(0.0, 0.01, 0.0)).thenRun(() -> damaged.setVelocity(movement));
    }
}

