/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.abilities.impl.onAttack;

import org.bukkit.NamespacedKey;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.abilities.impl.OnAttackAbility;
import xyz.nifeather.morph.abilities.options.PotionEffectOption;
import xyz.nifeather.morph.api.morphs.abilities.AbilityNames;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;

public class PotionOnAttackAbility
extends OnAttackAbility<PotionEffectOption> {
    @Resolved
    private MorphManager manager;

    @Override
    @NotNull
    public ISkillAbilityOptionHandler<PotionEffectOption> optionHandler() {
        return PotionEffectOption.OPTION_HANDLER;
    }

    @Override
    @NotNull
    public NamespacedKey getIdentifier() {
        return AbilityNames.POTION_ON_ATTACK;
    }

    @Override
    protected boolean requireValidOption() {
        return true;
    }

    @Override
    protected void onAttack(LivingEntity hurt, Player source) {
        DisguiseState state = this.manager.getDisguiseStateFor(source);
        if (state == null) {
            return;
        }
        PotionEffectOption option = (PotionEffectOption)this.getOptionFor(state);
        if (option == null || !option.isValid()) {
            return;
        }
        PotionEffectType effectType = option.effectType;
        if (effectType == null) {
            return;
        }
        PotionEffect effect = new PotionEffect(effectType, option.duration, option.amplifier, false);
        hurt.addPotionEffect(effect);
    }
}

