/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.SkinParts;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.manager.player.PlayerManager;
import com.github.retrooper.packetevents.protocol.entity.pose.EntityPose;
import com.github.retrooper.packetevents.protocol.player.GameMode;
import com.github.retrooper.packetevents.protocol.player.HumanoidArm;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfoRemove;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfoUpdate;
import com.mojang.authlib.GameProfile;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.inventory.MainHand;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.LivingEntityWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntries;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntry;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.BuildFailedException;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.PlayerProperties;
import xyz.nifeather.morph.utilities.GameProfileUtils;

public class PlayerWatcher
extends LivingEntityWatcher {
    private final PlayerProperties playerDisguiseProperties = DisguiseProperties.INSTANCE.getOrThrow(PlayerProperties.class);

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.PLAYER);
    }

    public PlayerWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.PLAYER);
    }

    @Override
    protected void doSync() {
        super.doSync();
        Player bindingPlayer = this.getBindingPlayer();
        this.writeTemp(ValueIndex.PLAYER.SKIN_FLAGS, (byte)((SkinParts)bindingPlayer.getClientOption(ClientOption.SKIN_PARTS)).getRaw());
        if (!this.isValuePresent(ValueIndex.PLAYER.MAINHAND)) {
            this.writeTemp(ValueIndex.PLAYER.MAINHAND, bindingPlayer.getMainHand() == MainHand.LEFT ? HumanoidArm.LEFT : HumanoidArm.RIGHT);
        }
    }

    @Override
    protected <X> void onPropertyWrite(SingleProperty<X> property, X value) {
        if (property.equals(this.playerDisguiseProperties.MAIN_HAND)) {
            PlayerProperties.MainHandStatus handStatus = (PlayerProperties.MainHandStatus)((Object)value);
            if (handStatus == PlayerProperties.MainHandStatus.NOTSET) {
                return;
            }
            MainHand hand = handStatus.bindingHand;
            assert (hand != null);
            this.writePersistent(ValueIndex.PLAYER.MAINHAND, hand == MainHand.LEFT ? HumanoidArm.LEFT : HumanoidArm.RIGHT);
        }
        super.onPropertyWrite(property, value);
    }

    @Override
    protected <X> void onEntryWrite(CustomEntry<X> entry, X oldVal, X newVal) {
        super.onEntryWrite(entry, oldVal, newVal);
        if (entry.equals(CustomEntries.PROFILE) && this.isPlayerOnline() && !this.isSilent()) {
            List<PacketWrapper<?>> spawnPackets;
            Player player = this.getBindingPlayer();
            List<Player> affected = this.getAffectedPlayers(player);
            if (affected.isEmpty()) {
                return;
            }
            try {
                spawnPackets = this.buildSpawnPackets();
            }
            catch (BuildFailedException e) {
                this.logger.error("Build spawn packet FAILED for player skin update! not continuing", (Throwable)e);
                return;
            }
            PlayerManager protocol = PacketEvents.getAPI().getPlayerManager();
            affected.forEach(p -> spawnPackets.forEach(packet -> protocol.sendPacket(p, packet)));
        }
        if (entry.equals(CustomEntries.ANIMATION)) {
            String animId;
            switch (animId = String.valueOf(newVal)) {
                case "lay": {
                    this.remove(ValueIndex.PLAYER.POSE);
                    this.writePersistent(ValueIndex.PLAYER.POSE, EntityPose.SLEEPING);
                    Location playerPos = this.getBindingPlayer().getLocation();
                    Vector3i vec3i = new Vector3i(playerPos.getBlockX(), playerPos.getBlockY(), playerPos.getBlockZ());
                    this.writePersistent(ValueIndex.PLAYER.BED_POS, Optional.of(vec3i));
                    break;
                }
                case "crawl": {
                    this.resetValues();
                    this.writePersistent(ValueIndex.PLAYER.POSE, EntityPose.SWIMMING);
                    break;
                }
                case "standup": 
                case "reset": {
                    this.writePersistent(ValueIndex.PLAYER.POSE, SpigotConversionUtil.fromBukkitPose((Pose)this.getBindingPlayer().getPose()));
                    this.resetValues();
                }
            }
        }
    }

    public List<PacketWrapper<?>> buildPlayerInfoPackets() {
        UUID spawnUUID = this.readEntryOrThrow(CustomEntries.SPAWN_UUID);
        WrapperPlayServerPlayerInfoRemove infoRemove = new WrapperPlayServerPlayerInfoRemove(List.of(spawnUUID));
        UserProfile packetProfile = GameProfileUtils.toPacketEventsUserProfile(this.readEntryOrThrow(CustomEntries.PROFILE));
        packetProfile.setUUID(spawnUUID);
        WrapperPlayServerPlayerInfoUpdate infoUpdate = new WrapperPlayServerPlayerInfoUpdate(EnumSet.of(WrapperPlayServerPlayerInfoUpdate.Action.ADD_PLAYER, WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_LISTED), new WrapperPlayServerPlayerInfoUpdate.PlayerInfo[]{new WrapperPlayServerPlayerInfoUpdate.PlayerInfo(packetProfile, this.readEntryOrDefault(CustomEntries.PROFILE_LISTED, false).booleanValue(), 114514, GameMode.defaultGameMode(), null, null, 0, true)});
        return List.of(infoRemove, infoUpdate);
    }

    @Override
    public List<PacketWrapper<?>> buildSpawnPackets() throws BuildFailedException {
        ObjectArrayList list = new ObjectArrayList();
        GameProfile gameProfile = this.readEntryOrThrow(CustomEntries.PROFILE);
        if (gameProfile.name().isBlank()) {
            throw new IllegalArgumentException("GameProfile name is empty!");
        }
        list.addAll(this.buildPlayerInfoPackets());
        list.addAll(super.buildSpawnPackets());
        return list;
    }

    private void resetValues() {
        this.remove(ValueIndex.PLAYER.POSE);
        this.writePersistent(ValueIndex.PLAYER.BED_POS, Optional.empty());
        this.remove(ValueIndex.PLAYER.BED_POS);
    }
}

