/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.LivingEntityWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.RabbitProperties;

public class RabbitWatcher
extends LivingEntityWatcher {
    public RabbitWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.RABBIT);
    }

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.RABBIT);
    }

    public Rabbit.Type getType() {
        return Arrays.stream(Rabbit.Type.values()).toList().get(this.read(ValueIndex.RABBIT.RABBIT_TYPE));
    }

    @Override
    protected <X> void onPropertyWrite(SingleProperty<X> property, X value) {
        RabbitProperties properties = DisguiseProperties.INSTANCE.getOrThrow(RabbitProperties.class);
        if (property.equals(properties.VARIANT)) {
            Rabbit.Type val = (Rabbit.Type)value;
            this.writePersistent(ValueIndex.RABBIT.RABBIT_TYPE, val == Rabbit.Type.THE_KILLER_BUNNY ? 99 : val.ordinal());
        }
        super.onPropertyWrite(property, value);
    }

    @Override
    public void writeToCompound(CompoundTag nbt) {
        super.writeToCompound(nbt);
        nbt.putInt("RabbitType", this.read(ValueIndex.RABBIT.RABBIT_TYPE).intValue());
    }
}

