/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.EntitySelectorArgumentResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.abilities.AbilityManager;
import xyz.nifeather.morph.api.FeatherMorphAPI;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.values.AbstractValues;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.values.SingleValue;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.commands.brigadier.BrigadierCommand;
import xyz.nifeather.morph.interfaces.IManagePlayerData;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;
import xyz.nifeather.morph.skills.ISkill;
import xyz.nifeather.morph.skills.SkillManager;
import xyz.nifeather.morph.storage.skill.ISkillAbilityOption;
import xyz.nifeather.morph.storage.skill.SkillsConfigurationStoreNew;

public class DebugTestCommand
extends BrigadierCommand {
    @Resolved
    private MorphManager morphManager;

    @Override
    public String getPermissionRequirement() {
        return null;
    }

    @Override
    public boolean register(Commands dispatcher) {
        dispatcher.register(((LiteralArgumentBuilder)Commands.literal((String)"listRaw").then(Commands.argument((String)"who", (ArgumentType)ArgumentTypes.player()).executes(ctx -> {
            List players = (List)((PlayerSelectorArgumentResolver)ctx.getArgument("who", PlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)ctx.getSource());
            if (players.isEmpty()) {
                return 0;
            }
            Player player = (Player)players.getFirst();
            CommandSender source = ((CommandSourceStack)ctx.getSource()).getSender();
            for (DisguiseMeta meta : this.morphManager.getPlayerMeta((OfflinePlayer)player).getUnlockedDisguises()) {
                source.sendMessage(meta.rawIdentifier);
            }
            return 1;
        }))).build());
        dispatcher.register(((LiteralArgumentBuilder)Commands.literal((String)"testDataStore").executes(ctx -> {
            try {
                IManagePlayerData store = this.morphManager.getDataStore();
                CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
                Bukkit.getAsyncScheduler().runDelayed((Plugin)this.plugin, task -> {
                    sender.sendMessage("Test1");
                    UUID UUID2 = UUID.fromString("0-0-0-0-0");
                    store.getPlayerMeta(Bukkit.getOfflinePlayer((UUID)UUID2));
                }, 50L, TimeUnit.MILLISECONDS);
                sender.sendMessage("Test2");
                UUID UUID2 = UUID.fromString("0-0-0-0-0");
                store.getPlayerMeta(Bukkit.getOfflinePlayer((UUID)UUID2));
            }
            catch (Throwable t) {
                this.logger.warn("Exception!", t);
            }
            return 1;
        })).build());
        dispatcher.register(((LiteralArgumentBuilder)Commands.literal((String)"validate_skill_ability").executes(this::validateSkillAbilities)).build());
        dispatcher.register(((LiteralArgumentBuilder)Commands.literal((String)"mannequinswing").then(Commands.argument((String)"entity", (ArgumentType)ArgumentTypes.entity()).executes(this::execMannequinSwing))).build());
        dispatcher.register(((LiteralArgumentBuilder)Commands.literal((String)"debugForValue").then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).suggests(this::suggestValueIndex).executes(this::getDebugValue))).build());
        return true;
    }

    private CompletableFuture<Suggestions> suggestValueIndex(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return CompletableFuture.supplyAsync(() -> {
            String remaining = builder.getRemainingLowerCase();
            Arrays.stream(ValueIndex.class.getFields()).map(Field::getName).filter(name -> name.toLowerCase().contains(remaining)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.build();
        });
    }

    private int getDebugValue(CommandContext<CommandSourceStack> context) {
        String filter = StringArgumentType.getString(context, (String)"value");
        Field field = Arrays.stream(ValueIndex.class.getFields()).filter(f -> f.getName().equalsIgnoreCase(filter)).findFirst().orElse(null);
        if (field == null) {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage("No such field: " + filter);
            return 0;
        }
        AbstractValues instance = null;
        try {
            instance = (AbstractValues)field.get(null);
        }
        catch (IllegalAccessException e) {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage("Failed to get: " + e.getMessage());
            this.logger.error("Failed to get field", (Throwable)e);
            return 0;
        }
        ObjectArrayList list = new ObjectArrayList(instance.getValues());
        list.sort(Comparator.comparingInt(SingleValue::index));
        list.forEach(sv -> ((CommandSourceStack)context.getSource()).getSender().sendMessage("%s \u4e0a\u7684SV\u662f %s".formatted(sv.index(), sv.name())));
        return 1;
    }

    private int execMannequinSwing(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        List entity = (List)((EntitySelectorArgumentResolver)context.getArgument("entity", EntitySelectorArgumentResolver.class)).resolve((CommandSourceStack)context.getSource());
        entity.forEach(e -> {
            if (!(e instanceof Mannequin)) {
                return;
            }
            Mannequin mannequin = (Mannequin)e;
            mannequin.swingMainHand();
            ((CommandSourceStack)context.getSource()).getSender().sendMessage("Call swing!");
        });
        return 1;
    }

    private int validateSkillAbilities(CommandContext<CommandSourceStack> commandSourceStackCommandContext) {
        FeatherMorphAPI api = FeatherMorphAPI.instance();
        assert (api != null);
        SkillsConfigurationStoreNew skillConfigs = api.directAccess().getGlobalDependency(SkillsConfigurationStoreNew.class);
        AbilityManager abilityManager = api.directAccess().abilityManager();
        List<String> targets = Arrays.stream(EntityType.values()).filter(t -> !t.equals((Object)EntityType.UNKNOWN)).map(t -> t.key().asString()).toList();
        SkillManager skillHandler = api.directAccess().skillHandler();
        Bukkit.broadcast((Component)Component.text((String)"Testing abilitymanager#getOptionsFor for any mc id"));
        try {
            for (String id : targets) {
                Map<NamespacedKey, ISkillAbilityOption> xx = abilityManager.getOptionsFor(id);
                this.logger.info("%s no error: %s".formatted(id, xx));
            }
        }
        catch (Exception e) {
            Bukkit.broadcast((Component)Component.text((String)("Error! " + e.getMessage())));
            this.logger.error("Error!", (Throwable)e);
        }
        Bukkit.broadcast((Component)Component.text((String)"Now for skills..."));
        try {
            for (String id : targets) {
                ISkill<?> skill = skillHandler.lookupDisguiseSkill(id);
                if (!skillHandler.hasSkill(id)) continue;
                Object option = skillHandler.lookupOptionFor(skill, id);
                this.logger.info("%s no error: %s".formatted(id, option));
            }
        }
        catch (Exception e) {
            Bukkit.broadcast((Component)Component.text((String)("Error! " + e.getMessage())));
            this.logger.error("Error!", (Throwable)e);
        }
        Bukkit.broadcast((Component)Component.text((String)"Test complete"));
        return 1;
    }

    @Override
    @NotNull
    public String name() {
        return "fmdebug";
    }

    @Override
    public FormattableMessage getHelpMessage() {
        return null;
    }
}

