/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands.brigadier.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.providers.disguise.DisguiseProvider;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;

public class DisguiseIdentifierArgumentType
extends MorphPluginObject
implements CustomArgumentType<String, String> {
    private static final List<String> EXAMPLES = List.of("allay", "minecraft:allay", "player:Icalingua");
    public static final DisguiseIdentifierArgumentType ALL_AVAILABLE = new DisguiseIdentifierArgumentType(false);
    public static final DisguiseIdentifierArgumentType FOR_PLAYER = new DisguiseIdentifierArgumentType(true);
    private final boolean usePlayerAvailableDisguises;
    private final List<String> cachedAvailableIDs = ObjectLists.synchronize((ObjectList)new ObjectArrayList());
    @Resolved(shouldSolveImmediately=true)
    private MorphManager morphs;

    public static String getArgument(CommandContext<?> context, String name) {
        return (String)context.getArgument(name, String.class);
    }

    protected DisguiseIdentifierArgumentType(boolean usePlayerAvailableDisguises) {
        this.usePlayerAvailableDisguises = usePlayerAvailableDisguises;
    }

    @NotNull
    public String parse(StringReader reader) throws CommandSyntaxException {
        int begin = reader.getCursor();
        if (!reader.canRead()) {
            reader.skip();
        }
        while (reader.canRead() && !Character.isWhitespace(reader.peek())) {
            reader.skip();
        }
        return reader.getString().substring(begin, reader.getCursor());
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return this.usePlayerAvailableDisguises ? this.suggestPlayerDisguises(context, builder) : this.suggestAllDisguises(context, builder);
    }

    private <S> CompletableFuture<Suggestions> suggestPlayerDisguises(CommandContext<S> context, SuggestionsBuilder builder) {
        Object object = context.getSource();
        if (!(object instanceof CommandSourceStack)) {
            return builder.buildFuture();
        }
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        Entity source = commandSourceStack.getExecutor();
        if (!(source instanceof Player)) {
            return CompletableFuture.completedFuture(builder.build());
        }
        Player player = (Player)source;
        String input = builder.getRemainingLowerCase();
        List<DisguiseMeta> availableDisguises = this.morphs.getAvaliableDisguisesFor(player);
        return CompletableFuture.supplyAsync(() -> {
            for (DisguiseMeta disguiseMeta : availableDisguises) {
                String name = disguiseMeta.getKey();
                if (!name.toLowerCase().contains(input)) continue;
                builder.suggest(name);
            }
            return builder.build();
        });
    }

    private <S> CompletableFuture<Suggestions> suggestAllDisguises(CommandContext<S> context, SuggestionsBuilder builder) {
        return CompletableFuture.supplyAsync(() -> {
            String input = builder.getRemainingLowerCase();
            if (!this.cachedAvailableIDs.isEmpty()) {
                this.cachedAvailableIDs.forEach(id -> {
                    if (!id.toLowerCase().contains(input)) {
                        return;
                    }
                    builder.suggest(id);
                });
                return builder.build();
            }
            for (DisguiseProvider p : MorphManager.getProviders()) {
                if (Objects.equals(p, MorphManager.fallbackProvider)) continue;
                String providerNamespace = p.getNameSpace();
                p.getAllAvailableDisguises().forEach(path -> {
                    String id = providerNamespace + ":" + path;
                    if (id.toLowerCase().contains(input)) {
                        builder.suggest(id);
                    }
                    this.cachedAvailableIDs.add(id);
                });
                builder.suggest(providerNamespace + ":@all");
                this.cachedAvailableIDs.add(providerNamespace + ":@all");
            }
            return builder.build();
        });
    }

    @NotNull
    public ArgumentType<String> getNativeType() {
        return StringArgumentType.greedyString();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

