/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands.brigadier.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ValueMapArgumentType
implements CustomArgumentType<Map<String, String>, String> {
    public static final Collection<String> EXAMPLES = ObjectArrayList.of((Object[])new String[]{"[foo=bar]", "[foo=bar, aabb=\"ccdd\"]"});
    private static final Map<String, List<String>> EMPTY_MAP = new HashMap<String, List<String>>();
    private final Map<String, List<String>> properties = new ConcurrentHashMap<String, List<String>>();
    private static final Component ERR_NO_BRACKET = Component.translatableWithFallback((String)"morphclient.parsing.bracket.start", (String)"Expected square bracket (\"[\") to start a string");
    private static final Component ERR_EMPTY_KEY = Component.translatableWithFallback((String)"morphclient.parsing.key.empty", (String)"May not have a empty key");
    private static final Component ERR_SUGGEST_FAIL = Component.translatableWithFallback((String)"morphclient.parsing.fail", (String)"Failed to suggest properties!");

    public @Unmodifiable Map<String, List<String>> properties() {
        return new Object2ObjectOpenHashMap(this.properties);
    }

    public void setProperty(String key, @Nullable List<String> values) {
        if (values == null) {
            this.unsetProperty(key);
            return;
        }
        this.properties.put(key, values);
    }

    public void unsetProperty(String key) {
        this.properties.remove(key);
    }

    public ValueMapArgumentType(Map<String, List<String>> properties) {
        this.properties.putAll(properties);
    }

    public ValueMapArgumentType() {
        this(EMPTY_MAP);
    }

    public static ValueMapArgumentType withArguments(Map<String, List<String>> properties) {
        return new ValueMapArgumentType(properties);
    }

    public static Map<String, String> get(String name, CommandContext<CommandSourceStack> context) {
        return (Map)context.getArgument(name, Map.class);
    }

    private static SimpleCommandExceptionType errorForKeyNoValue(String key) {
        return new SimpleCommandExceptionType((Message)Component.translatableWithFallback((String)"morphclient.parsing.value_map.no_value", (String)"Missing value for key '%s'", (Object[])new Object[]{key}));
    }

    private static SimpleCommandExceptionType errorForDuplicateKey(String key) {
        return new SimpleCommandExceptionType((Message)Component.translatableWithFallback((String)"morphclient.parsing.value_map.duplicate_key", (String)"Duplicate key '%s'", (Object[])new Object[]{key}));
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader masterReader = new StringReader(builder.getInput());
        masterReader.setCursor(builder.getStart());
        return CompletableFuture.supplyAsync(() -> this.doSuggest(masterReader, builder));
    }

    private Suggestions doSuggest(StringReader masterReader, SuggestionsBuilder defaultBuilder) {
        SuggestionsBuilder finalBuilder;
        if (masterReader.peek() == '[') {
            masterReader.skip();
        }
        KeyValuePair keyValuePair = new KeyValuePair(null, null, masterReader.getCursor(), masterReader.getCursor(), false);
        try {
            List<KeyValuePair> parseResults = this.parseAll(masterReader, ',', ']');
            keyValuePair = parseResults.isEmpty() ? keyValuePair : parseResults.getLast();
        }
        catch (Throwable t) {
            return defaultBuilder.build();
        }
        StringReader peekReader = new StringReader(masterReader);
        peekReader.setCursor(masterReader.canRead() ? masterReader.getCursor() : peekReader.getTotalLength() - 1);
        if (peekReader.peek() == ']') {
            return defaultBuilder.build();
        }
        String keyInput = keyValuePair.key == null ? "" : keyValuePair.key;
        boolean hasMatchKey = this.properties.keySet().stream().anyMatch(k -> k.equals(keyInput));
        if (!keyValuePair.hasValue) {
            finalBuilder = defaultBuilder.createOffset(keyValuePair.keyCursor);
            if (!hasMatchKey) {
                boolean isEmptyInput = keyValuePair.key == null;
                this.properties.keySet().forEach(k -> {
                    if (isEmptyInput) {
                        finalBuilder.suggest(k);
                    } else if (k.contains(keyInput)) {
                        finalBuilder.suggest(k);
                    }
                });
            }
        } else {
            String valueInput = keyValuePair.value == null ? "" : keyValuePair.value;
            boolean isEmptyInput = keyValuePair.value == null;
            finalBuilder = defaultBuilder.createOffset(keyValuePair.valueCursor);
            List availableValues = this.properties.getOrDefault(keyValuePair.key, List.of());
            availableValues.forEach(v -> {
                if (isEmptyInput) {
                    finalBuilder.suggest(v);
                } else if (v.contains(valueInput)) {
                    finalBuilder.suggest(v);
                }
            });
        }
        return finalBuilder.build();
    }

    public Map<String, String> parse(StringReader reader) throws CommandSyntaxException {
        if (reader.peek() != '[') {
            throw new SimpleCommandExceptionType((Message)ERR_NO_BRACKET).createWithContext((ImmutableStringReader)reader);
        }
        reader.skip();
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        List<KeyValuePair> values = this.parseAll(reader, ',', ']');
        StringReader peekReader = new StringReader(reader);
        peekReader.setCursor(reader.canRead() ? reader.getCursor() : reader.getTotalLength() - 1);
        if (peekReader.peek() != ']') {
            throw new SimpleCommandExceptionType((Message)Component.translatable((String)"parsing.expected", (Object[])new Object[]{"]"})).createWithContext((ImmutableStringReader)reader);
        }
        reader.skip();
        for (KeyValuePair pair : values) {
            if (pair.key == null) {
                reader.setCursor(pair.keyCursor);
                throw new SimpleCommandExceptionType((Message)ERR_EMPTY_KEY).createWithContext((ImmutableStringReader)reader);
            }
            if (pair.value == null) {
                reader.setCursor(pair.keyCursor);
                throw ValueMapArgumentType.errorForKeyNoValue(pair.key).createWithContext((ImmutableStringReader)reader);
            }
            if (map.containsKey(pair.key)) {
                reader.setCursor(pair.keyCursor);
                throw ValueMapArgumentType.errorForDuplicateKey(pair.key).createWithContext((ImmutableStringReader)reader);
            }
            map.put(pair.key, pair.value);
        }
        return map;
    }

    public List<KeyValuePair> parseAll(StringReader reader, char splitter, char endOfString) throws CommandSyntaxException {
        ObjectArrayList list = new ObjectArrayList();
        while (reader.canRead()) {
            KeyValuePair pair = this.parseOnce(reader, splitter, endOfString);
            list.add(pair);
            if (pair.key != null) continue;
            break;
        }
        return list;
    }

    @NotNull
    public KeyValuePair parseOnce(StringReader reader, char terminator, char endOfString) throws CommandSyntaxException {
        StringBuilder keyStringBuilder = new StringBuilder();
        StringBuilder valueStringBuilder = null;
        int keyCursor = reader.getCursor();
        int valueCursor = reader.getCursor();
        boolean isKey = true;
        String key = null;
        String value = null;
        while (reader.canRead()) {
            StringBuilder builder;
            char last = reader.peek(0);
            char current = reader.read();
            if (current == endOfString || current == terminator) break;
            if (isKey && last == ' ') {
                keyCursor = reader.getCursor();
            }
            StringBuilder stringBuilder = builder = isKey ? keyStringBuilder : valueStringBuilder;
            if (current == '=' && isKey) {
                isKey = false;
                if (reader.canRead()) {
                    if (StringReader.isQuotedStringStart((char)reader.peek())) {
                        valueCursor = reader.getCursor() + 1;
                        continue;
                    }
                    valueCursor = reader.getCursor();
                    continue;
                }
                valueCursor = reader.getCursor();
                continue;
            }
            if (!isKey && builder == null) {
                builder = valueStringBuilder = new StringBuilder();
            }
            if (builder.isEmpty() && Character.isWhitespace(current)) continue;
            if (StringReader.isQuotedStringStart((char)current)) {
                StringReader quoteReader = new StringReader(reader);
                String str = quoteReader.readStringUntil(current);
                reader.setCursor(quoteReader.getCursor());
                builder.append(str);
                continue;
            }
            builder.append(current);
        }
        if (!keyStringBuilder.isEmpty()) {
            key = keyStringBuilder.toString();
        }
        if (valueStringBuilder != null) {
            value = valueStringBuilder.toString();
        }
        return new KeyValuePair(key, value, keyCursor, valueCursor, !isKey);
    }

    @NotNull
    public ArgumentType<String> getNativeType() {
        return StringArgumentType.greedyString();
    }

    @NotNull
    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public record KeyValuePair(@Nullable String key, @Nullable String value, int keyCursor, int valueCursor, boolean hasValue) {
    }
}

