/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands.subcommands.plugin.management;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.commands.brigadier.IConvertibleBrigadier;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.strings.CommandStrings;
import xyz.nifeather.morph.messages.strings.HelpStrings;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class ForceUnmorphSubCommand
extends MorphPluginObject
implements IConvertibleBrigadier {
    @Resolved
    private MorphManager manager;

    @Override
    @NotNull
    public String name() {
        return "unmorph";
    }

    @Override
    @Nullable
    public String permission() {
        return "feathermorph.manage.unmorph";
    }

    @Override
    public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
        parentBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)this.name()).requires(this::checkPermission)).then(Commands.argument((String)"who", (ArgumentType)ArgumentTypes.players()).executes(this::execute)));
    }

    private int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        List players = (List)((PlayerSelectorArgumentResolver)context.getArgument("who", PlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)context.getSource());
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        players.forEach(player -> {
            if (!player.isOnline()) {
                return;
            }
            this.manager.unMorph(sender, (Player)player, true, true);
            MessageUtils.send(sender, CommandStrings.unMorphedSomeoneString().resolve("who", player.getName()));
        });
        return 1;
    }

    @Override
    public FormattableMessage getHelpMessage() {
        return HelpStrings.manageUnmorphDescription();
    }
}

