/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.events.mirror.impl;

import io.papermc.paper.event.player.PlayerArmSwingEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.events.PlayerTracker;
import xyz.nifeather.morph.events.mirror.ExecutorHub;
import xyz.nifeather.morph.events.mirror.IExecutor;
import xyz.nifeather.morph.misc.PlayerOperationSimulator;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.storage.mirrorlogging.OperationType;
import xyz.nifeather.morph.utilities.DisguiseUtils;
import xyz.nifeather.morph.utilities.ItemUtils;

public abstract class AbstractExecutor
extends MorphPluginObject
implements IExecutor<Player, ItemStack, Action> {
    protected final ExecutorHub executorHub;
    @Resolved(shouldSolveImmediately=true)
    private MorphManager manager;
    @Resolved(shouldSolveImmediately=true)
    private MorphClientHandler clientHandler;
    @Resolved
    private PlayerTracker tracker;
    @Resolved
    private PlayerOperationSimulator operationSimulator;

    public AbstractExecutor(ExecutorHub executorHub) {
        this.executorHub = executorHub;
    }

    protected void logOperation(Player source, Player targetPlayer, OperationType type) {
        this.executorHub.logOperation(source, targetPlayer, type);
    }

    protected PlayerOperationSimulator operationSimulator() {
        return this.operationSimulator;
    }

    protected PlayerTracker tracker() {
        return this.tracker;
    }

    protected MorphClientHandler clientHandler() {
        return this.clientHandler;
    }

    protected MorphManager morphManager() {
        return this.manager;
    }

    protected boolean playerNotDisguised(Player player) {
        return this.manager.getDisguiseStateFor(player) == null;
    }

    @Nullable
    protected String getTargetControlFor(Player source) {
        return this.executorHub.getControl(source);
    }

    @Contract(value="_, null-> false; _, !null -> _")
    protected boolean playerInDistance(@NotNull Player source, @Nullable Player target) {
        if (target == null || !source.hasPermission("feathermorph.mirror") || target.hasPermission("feathermorph.mirror.immune") || target.getOpenInventory().getType() != InventoryType.CRAFTING || target.isSleeping() || target.isDead() || !DisguiseUtils.gameModeMirrorable(target)) {
            return false;
        }
        boolean isInSameWorld = target.getWorld().equals((Object)source.getWorld());
        int normalDistance = this.executorHub.getControlDistance();
        return normalDistance == -1 || normalDistance != 0 && isInSameWorld && target.getLocation().distance(source.getLocation()) <= (double)normalDistance;
    }

    protected void simulateOperationAsync(Action action, Player targetPlayer, Player source, Consumer<Boolean> callback) {
        AtomicBoolean success = new AtomicBoolean(false);
        targetPlayer.getScheduler().run((Plugin)this.plugin, task -> {
            success.set(this.simulateOperation(action, targetPlayer, source));
            callback.accept(success.get());
        }, () -> {});
    }

    protected boolean simulateOperation(Action action, Player targetPlayer, Player source) {
        if (this.tracker().interactingThisTick(targetPlayer)) {
            return false;
        }
        boolean isRightClick = action.isRightClick();
        PlayerOperationSimulator.SimulateResult result = isRightClick ? this.operationSimulator().simulateRightClick(targetPlayer) : this.operationSimulator().simulateLeftClick(targetPlayer);
        boolean success = false;
        if (result.success()) {
            boolean allowed;
            Material itemInUse = targetPlayer.getEquipment().getItem(result.hand()).getType();
            if ((!isRightClick || !ItemUtils.isContinuousUsable(itemInUse) || result.forceSwing()) && (allowed = new PlayerArmSwingEvent(targetPlayer, result.hand()).callEvent())) {
                targetPlayer.swingHand(result.hand());
            }
            success = true;
        }
        return success;
    }
}

