/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.PluginManager;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.config.ConfigOption;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.misc.BlockDestroyHandler;
import xyz.nifeather.morph.misc.NmsRecord;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;

public class PlayerOperationSimulator
extends MorphPluginObject {
    private final Map<org.bukkit.entity.Player, BlockDestroyHandler> playerHandlerMap = new Object2ObjectOpenHashMap();
    private final Bindable<Integer> destroyTimeout = new Bindable<Integer>(40);
    private final float blockReachDistance = 4.5f;
    private final float entityReachDistance = 3.0f;
    private final PluginManager pluginManager = Bukkit.getPluginManager();

    @Initializer
    private void load(MorphConfigManager config) {
        this.addSchedule(this::update);
        config.bind(this.destroyTimeout, ConfigOption.MIRROR_DESTROY_TIMEOUT);
    }

    private void update() {
        this.addSchedule(this::update, 5);
        Object2ObjectOpenHashMap list = new Object2ObjectOpenHashMap(this.playerHandlerMap);
        long currentTick = this.plugin.getCurrentTick();
        list.forEach((p, i) -> {
            if (!p.isOnline()) {
                this.playerHandlerMap.remove(p);
                return;
            }
            if (currentTick - i.getLastUpdate() >= (long)this.destroyTimeout.get().intValue()) {
                i.setProgress(-1.0f, currentTick);
                this.playerHandlerMap.remove(p);
            }
        });
    }

    private RayTraceResult rayTrace(org.bukkit.entity.Player player) {
        Location eyeLoc = player.getEyeLocation();
        return player.getWorld().rayTrace(eyeLoc, eyeLoc.getDirection(), 4.5, FluidCollisionMode.NEVER, false, 0.0, e -> {
            if (e instanceof org.bukkit.entity.Player) {
                org.bukkit.entity.Player p = (org.bukkit.entity.Player)e;
                return !e.equals((Object)player) && p.getGameMode() != GameMode.SPECTATOR;
            }
            return true;
        });
    }

    public SimulateResult simulateLeftClick(org.bukkit.entity.Player player) {
        Entity targetEntity;
        if (player.isBlocking()) {
            return SimulateResult.fail();
        }
        ServerPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        if (nmsPlayer.isUsingItem()) {
            return SimulateResult.fail();
        }
        RayTraceResult traceResult = this.rayTrace(player);
        Block targetBlock = traceResult == null ? null : traceResult.getHitBlock();
        Entity entity = targetEntity = traceResult == null ? null : traceResult.getHitEntity();
        if (targetEntity != null && targetEntity.getLocation().distance(player.getLocation()) > 3.0) {
            targetEntity = null;
        }
        BlockDestroyHandler destroyHandler = this.playerHandlerMap.getOrDefault(player, null);
        if ((targetBlock == null || targetEntity != null) && destroyHandler != null) {
            destroyHandler.changeBlock(null);
        }
        if (targetEntity != null) {
            if (player.getLocation().distance(targetEntity.getLocation()) > 3.0) {
                return SimulateResult.success(EquipmentSlot.HAND);
            }
            player.attack(targetEntity);
            return SimulateResult.success(EquipmentSlot.HAND);
        }
        if (targetBlock == null) {
            return SimulateResult.success(EquipmentSlot.HAND);
        }
        if (player.getGameMode() == GameMode.ADVENTURE) {
            net.minecraft.world.item.ItemStack item = net.minecraft.world.item.ItemStack.fromBukkitCopy((ItemStack)Objects.requireNonNull(player.getEquipment(), "Null equipment?").getItemInMainHand());
            AdventureModePredicate canBreak = (AdventureModePredicate)item.getComponents().get(DataComponents.CAN_BREAK);
            if (canBreak == null) {
                return SimulateResult.fail();
            }
            CraftBlock craftBlock = (CraftBlock)targetBlock;
            if (canBreak.predicates.stream().noneMatch(bp -> bp.matches(craftBlock.getHandle().getMinecraftWorld(), craftBlock.getPosition()))) {
                return SimulateResult.success(EquipmentSlot.HAND);
            }
        }
        if (destroyHandler == null) {
            destroyHandler = new BlockDestroyHandler(targetBlock, 0.0f, player);
            this.playerHandlerMap.put(player, destroyHandler);
        }
        if (!targetBlock.equals((Object)destroyHandler.getBlock())) {
            destroyHandler.changeBlock(targetBlock);
        }
        ServerLevel nmsWorld = destroyHandler.getNmsWorld();
        BlockState nmsBlock = destroyHandler.getNmsBlock();
        assert (nmsBlock != null);
        assert (nmsWorld != null);
        nmsBlock.attack((Level)nmsWorld, ((CraftBlock)targetBlock).getPosition(), (Player)nmsPlayer);
        float delta = nmsBlock.getDestroyProgress((Player)nmsPlayer, (BlockGetter)nmsWorld, ((CraftBlock)targetBlock).getPosition());
        float val = destroyHandler.getProgress();
        destroyHandler.setProgress(val += delta, this.plugin.getCurrentTick());
        return SimulateResult.success(EquipmentSlot.HAND);
    }

    public SimulateResult simulateRightClick(org.bukkit.entity.Player player) {
        Entity targetEntity;
        ServerPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        if (nmsPlayer.isUsingItem()) {
            nmsPlayer.releaseUsingItem();
            return SimulateResult.fail();
        }
        RayTraceResult traceResult = this.rayTrace(player);
        Block targetBlock = traceResult == null ? null : traceResult.getHitBlock();
        Entity entity = targetEntity = traceResult == null ? null : traceResult.getHitEntity();
        if (targetEntity != null && targetEntity.getLocation().distance(player.getLocation()) > 3.0) {
            targetEntity = null;
        }
        ItemStack itemInMainHand = player.getEquipment().getItem(EquipmentSlot.HAND);
        ItemStack itemInOffHand = player.getEquipment().getItem(EquipmentSlot.OFF_HAND);
        if (targetEntity != null) {
            Vector hitPos = traceResult.getHitPosition();
            hitPos.subtract(targetEntity.getLocation().toVector());
            if (this.tryUseItemOnEntity(player, targetEntity, itemInMainHand, InteractionHand.MAIN_HAND, hitPos)) {
                return SimulateResult.success(EquipmentSlot.HAND);
            }
            return SimulateResult.of(this.tryUseItemOnEntity(player, targetEntity, itemInOffHand, InteractionHand.OFF_HAND, hitPos), EquipmentSlot.OFF_HAND);
        }
        if (targetBlock != null) {
            BlockPos loc = ((CraftBlock)targetBlock).getPosition();
            Direction targetBlockDirection = null;
            BlockFace bukkitFace = player.getTargetBlockFace(5);
            bukkitFace = bukkitFace == null ? BlockFace.SELF : bukkitFace;
            switch (bukkitFace) {
                case DOWN: {
                    targetBlockDirection = Direction.DOWN;
                    break;
                }
                case UP: {
                    targetBlockDirection = Direction.UP;
                    break;
                }
                case NORTH: {
                    targetBlockDirection = Direction.NORTH;
                    break;
                }
                case SOUTH: {
                    targetBlockDirection = Direction.SOUTH;
                    break;
                }
                case WEST: {
                    targetBlockDirection = Direction.WEST;
                    break;
                }
                case EAST: {
                    targetBlockDirection = Direction.EAST;
                    break;
                }
                default: {
                    this.logger.error("Unknown BlockFace: " + String.valueOf(bukkitFace) + ", will not attempt 'useItemOn'!");
                }
            }
            if (targetBlockDirection != null) {
                BlockHitResult moving = new BlockHitResult(new Vec3((double)targetBlock.getX(), (double)targetBlock.getY(), (double)targetBlock.getZ()), targetBlockDirection, loc, false);
                if (this.tryUseItemOnBlock(player, itemInMainHand, InteractionHand.MAIN_HAND, moving)) {
                    return SimulateResult.success(EquipmentSlot.HAND, true);
                }
                if (this.tryUseItemOnBlock(player, itemInOffHand, InteractionHand.OFF_HAND, moving)) {
                    return SimulateResult.success(EquipmentSlot.OFF_HAND, true);
                }
            }
        }
        if (this.tryUseItemOnSelf(player, itemInMainHand, InteractionHand.MAIN_HAND)) {
            return SimulateResult.success(EquipmentSlot.HAND);
        }
        if (this.tryUseItemOnSelf(player, itemInOffHand, InteractionHand.OFF_HAND)) {
            return SimulateResult.success(EquipmentSlot.OFF_HAND);
        }
        return SimulateResult.fail();
    }

    private boolean tryUseItemOnSelf(org.bukkit.entity.Player player, ItemStack bukkitItem, InteractionHand hand) {
        PlayerInteractEvent event = new PlayerInteractEvent(player, Action.RIGHT_CLICK_AIR, bukkitItem, null, BlockFace.SELF);
        this.pluginManager.callEvent((Event)event);
        if (event.useItemInHand() != Event.Result.DENY) {
            NmsRecord record = NmsRecord.of(player);
            ServerPlayerGameMode manager = record.interactManager();
            return manager.useItem(record.nmsPlayer(), (Level)record.nmsWorld(), CraftItemStack.asNMSCopy((ItemStack)bukkitItem), hand).consumesAction();
        }
        return false;
    }

    private boolean tryUseItemOnBlock(org.bukkit.entity.Player player, ItemStack bukkitItem, InteractionHand nmsHand, BlockHitResult moving) {
        NmsRecord record = NmsRecord.of(player);
        ServerPlayerGameMode manager = record.interactManager();
        return manager.useItemOn(record.nmsPlayer(), (Level)record.nmsWorld(), CraftItemStack.asNMSCopy((ItemStack)bukkitItem), nmsHand, moving).consumesAction();
    }

    private boolean tryUseItemOnEntity(org.bukkit.entity.Player player, Entity targetEntity, ItemStack bukkitItem, InteractionHand hand, Vector hitPos) {
        PlayerInteractEntityEvent interactEntityEvent = new PlayerInteractEntityEvent(player, targetEntity);
        PlayerInteractAtEntityEvent interactAtEvent = new PlayerInteractAtEntityEvent(player, targetEntity, hitPos);
        this.pluginManager.callEvent((Event)interactEntityEvent);
        this.pluginManager.callEvent((Event)interactAtEvent);
        if (!interactAtEvent.isCancelled() && !interactEntityEvent.isCancelled()) {
            NmsRecord record = NmsRecord.of(player, targetEntity);
            ServerPlayer playerHandle = record.nmsPlayer();
            ServerLevel worldHandle = record.nmsWorld();
            net.minecraft.world.entity.Entity entityHandle = record.nmsEntity();
            ServerPlayerGameMode manager = record.interactManager();
            Vec3 vec = new Vec3(hitPos.getX(), hitPos.getY(), hitPos.getZ());
            assert (entityHandle != null);
            return entityHandle.interactAt((Player)playerHandle, vec, hand).consumesAction() || playerHandle.interactOn(entityHandle, hand).consumesAction() || manager.useItem(playerHandle, (Level)worldHandle, CraftItemStack.asNMSCopy((ItemStack)bukkitItem), hand).consumesAction();
        }
        return false;
    }

    public record SimulateResult(boolean success, EquipmentSlot hand, boolean forceSwing) {
        public static SimulateResult success(EquipmentSlot hand) {
            return SimulateResult.of(true, hand);
        }

        public static SimulateResult success(EquipmentSlot hand, boolean clickedOnBlock) {
            return SimulateResult.of(true, hand, clickedOnBlock);
        }

        public static SimulateResult fail() {
            return SimulateResult.of(false, null);
        }

        public static SimulateResult of(boolean success, EquipmentSlot hand) {
            return new SimulateResult(success, hand, false);
        }

        public static SimulateResult of(boolean success, EquipmentSlot hand, boolean clickedOnBlock) {
            return new SimulateResult(success, hand, clickedOnBlock);
        }
    }
}

