/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityProperties;
import xyz.nifeather.morph.utilities.DisguiseUtils;

public class ChickenProperties
extends BaseLivingEntityProperties<Chicken> {
    private final Map<String, Chicken.Variant> variantMap = new ConcurrentHashMap<String, Chicken.Variant>();
    public final SingleProperty<Chicken.Variant> VARIANT = this.createProperty("chicken/variant", Chicken.Variant.TEMPERATE, this::readChickenVariant, OutputHandles::writeKeyed);

    private void initVariantMap() {
        for (Chicken.Variant variant : RegistryAccess.registryAccess().getRegistry(RegistryKey.CHICKEN_VARIANT)) {
            this.variantMap.put(variant.key().asString(), variant);
        }
    }

    private Optional<Chicken.Variant> readChickenVariant(String propertyName, String string) throws ParseErrorException {
        return InputHandles.readRegistry(RegistryKey.CHICKEN_VARIANT, propertyName, string);
    }

    public ChickenProperties() {
        this.initVariantMap();
        this.VARIANT.withValidInput(this.variantMap.keySet()).withRandom(this.variantMap.values());
        this.registerSingle((SingleProperty<?>)this.VARIANT);
    }

    @Override
    @Nullable
    protected Chicken tryCastEntity(@Nullable Entity targetEntity) {
        Chicken chicken;
        return targetEntity instanceof Chicken ? (chicken = (Chicken)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Chicken chicken) {
        super.setupPropertiesFromEntity(meta, propertyHandler, chicken);
        propertyHandler.set(this.VARIANT, chicken.getVariant());
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        propertyHandler.set(this.VARIANT, DisguiseUtils.pick(this.VARIANT.getRandomValues()));
    }
}

