/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import com.mojang.authlib.GameProfile;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.messages.strings.CommandStrings;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyValidationException;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityProperties;
import xyz.nifeather.morph.utilities.GameProfileUtils;
import xyz.nifeather.morph.utilities.Uuids;

public class MannequinProperties
extends BaseLivingEntityProperties<Mannequin> {
    public final SingleProperty<Component> NPC_DESCRIPTION = this.createProperty("mannequin/description", Component.empty(), InputHandles::readComponentAny, OutputHandles::writeAdventureComponentJSON);
    public final SingleProperty<Boolean> HIDE_DESCRIPTION = this.createProperty("mannequin/hide_description", false, InputHandles::readBooleanRelaxed, OutputHandles::writeBoolean).withValidInput("true", "false");
    public final SingleProperty<Boolean> IMMOVABLE = SingleProperty.of("mannequin/immovable", false, InputHandles::immediateException, OutputHandles::writeBoolean, true).withValidInput("true", "false");
    public final SingleProperty<ResolvableProfile> SKIN = this.createProperty("mannequin/skin", GameProfileUtils.asResolvableProfile(new GameProfile(Uuids.NIL_UUID, "notset")), InputHandles::readResolvableSkinInput, OutputHandles::writeResolvableProfileAny);

    public MannequinProperties() {
        this.registerSingle(this.NPC_DESCRIPTION, this.HIDE_DESCRIPTION, this.SKIN, this.IMMOVABLE);
    }

    @Override
    @Nullable
    protected Mannequin tryCastEntity(@Nullable Entity targetEntity) {
        Mannequin mannequin;
        return targetEntity instanceof Mannequin ? (mannequin = (Mannequin)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Mannequin targetEntity) {
        super.setupPropertiesFromEntity(meta, propertyHandler, targetEntity);
        propertyHandler.set(this.SKIN, targetEntity.getProfile());
        Component description = targetEntity.getDescription();
        if (description != null) {
            propertyHandler.set(this.NPC_DESCRIPTION, description);
        }
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        propertyHandler.set(this.CUSTOM_NAME_VISIBLE, true);
    }

    @Override
    public void validateInput(Map<SingleProperty<?>, Object> result, Player player, boolean ignorePermissions) throws PropertyValidationException {
        super.validateInput(result, player, ignorePermissions);
        if (ignorePermissions) {
            return;
        }
        if (result.containsKey(this.SKIN) && !player.hasPermission("feathermorph.custom_skin")) {
            throw PropertyValidationException.forProperty("mannequin/skin").byMethod("MannequinProperties#validateInput").withLocalizableMessage(CommandStrings.noPermissionMessage()).withMessage("Player don't have permission for setting custom skin").create();
        }
        if (result.containsKey(this.NPC_DESCRIPTION) && !player.hasPermission("feathermorph.custom_text")) {
            throw PropertyValidationException.forProperty("mannequin/description").byMethod("MannequinProperties#validateInput").withLocalizableMessage(CommandStrings.noPermissionMessage()).withMessage("Player don't have permission for setting custom description").create();
        }
        if (result.containsKey(this.HIDE_DESCRIPTION) && !player.hasPermission("feathermorph.custom_text")) {
            throw PropertyValidationException.forProperty("mannequin/hide_description").byMethod("MannequinProperties#validateInput").withLocalizableMessage(CommandStrings.noPermissionMessage()).withMessage("Player don't have permission for setting custom description").create();
        }
    }
}

