/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import java.util.Optional;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Phantom;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityProperties;

public class PhantomProperties
extends BaseLivingEntityProperties<Phantom> {
    public final SingleProperty<Integer> SIZE = this.createProperty("phantom/size", 1, this::readPhantomSize, OutputHandles::writeInteger);

    private Optional<Integer> readPhantomSize(String propertyName, String string) throws ParseErrorException {
        Integer val = InputHandles.readInteger(propertyName, string).orElseThrow(() -> new ParseErrorException(propertyName, "readPhantomSize: Unable to parse phantom size"));
        InputHandles.throwIfOutOfBounds(propertyName, val, 1, 10);
        return Optional.of(val);
    }

    public PhantomProperties() {
        this.registerSingle((SingleProperty<?>)this.SIZE);
    }

    @Override
    @Nullable
    protected Phantom tryCastEntity(@Nullable Entity targetEntity) {
        Phantom phantom;
        return targetEntity instanceof Phantom ? (phantom = (Phantom)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Phantom targetEntity) {
        super.setupPropertiesFromEntity(meta, propertyHandler, targetEntity);
        propertyHandler.set(this.SIZE, targetEntity.getSize());
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
    }
}

