/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.integrations.residence;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.event.ResidenceChangedEvent;
import com.bekvon.bukkit.residence.event.ResidenceFlagChangeEvent;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.protection.ResidencePermissions;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.abilities.impl.FlyAbility;
import xyz.nifeather.morph.abilities.impl.SnowyAbility;
import xyz.nifeather.morph.api.events.gameplay.PlayerExecuteSkillEvent;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.strings.MorphStrings;

public class ResidenceEventProcessor
extends MorphPluginObject
implements Listener {
    @EventHandler
    public void onEnterResidence(ResidenceChangedEvent e) {
        Player player = e.getPlayer();
        ClaimedResidence newResidence = e.getTo();
        if (newResidence == null) {
            FlyAbility.unBlockPlayer(player, this);
            SnowyAbility.unBlockPlayer(player, this);
            return;
        }
        ResidencePermissions residencePermissions = newResidence.getPermissions();
        if (residencePermissions.playerHas(player, Flags.nofly, false)) {
            FlyAbility.blockPlayer(player, this);
        } else {
            FlyAbility.unBlockPlayer(player, this);
        }
        if (residencePermissions.playerHas(player, Flags.place, false)) {
            SnowyAbility.unBlockPlayer(player, this);
        } else {
            SnowyAbility.blockPlayer(player, this);
        }
    }

    @EventHandler
    public void onResidenceFlagChange(ResidenceFlagChangeEvent e) {
        ClaimedResidence residence = e.getResidence();
        ArrayList players = residence.getPlayersInResidence();
        String flagName = e.getFlag();
        FlagPermissions.FlagState newState = e.getNewState();
        if (flagName.equals(Flags.place.getName())) {
            boolean allowPlace = newState == FlagPermissions.FlagState.TRUE;
            players.forEach(p -> {
                if (!allowPlace) {
                    SnowyAbility.blockPlayer(p, this);
                } else {
                    SnowyAbility.unBlockPlayer(p, this);
                }
            });
        } else if (flagName.equals(Flags.nofly.getName())) {
            boolean canFly = newState == FlagPermissions.FlagState.FALSE || newState == FlagPermissions.FlagState.NEITHER;
            players.forEach(p -> {
                if (!canFly) {
                    FlyAbility.blockPlayer(p, this);
                } else {
                    FlyAbility.unBlockPlayer(p, this);
                }
            });
        }
    }

    @EventHandler
    public void onPlayerUseSkill(PlayerExecuteSkillEvent e) {
        Player player = e.getPlayer();
        ClaimedResidence residence = Residence.getInstance().getResidenceManager().getByLoc(player);
        if (residence == null) {
            return;
        }
        ResidencePermissions residencePermissions = residence.getPermissions();
        if (!residencePermissions.playerHas(player, Flags.use, false)) {
            e.setCancelled(true);
            MessageUtils.send((CommandSender)player, MorphStrings.regionBlockedSkillString());
        }
    }
}

