/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.mobs;

import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.entity.CraftVex;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Vex;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.nifeather.morph.FeatherMorphMain;

public class MorphBukkitVexHolder {
    private static final Logger log = LoggerFactory.getLogger(MorphBukkitVexHolder.class);
    private final net.minecraft.world.entity.monster.Vex vex;
    private final Player owner;

    public MorphBukkitVexHolder(Vex bukkitVex, org.bukkit.entity.Player bukkitPlayer) {
        this(((CraftVex)bukkitVex).getHandle(), (Player)((CraftPlayer)bukkitPlayer).getHandle());
    }

    public MorphBukkitVexHolder(net.minecraft.world.entity.monster.Vex nmsVex, Player owner) {
        Objects.requireNonNull(nmsVex, "Null NMS Vex");
        Objects.requireNonNull(owner, "Null owner");
        this.vex = nmsVex;
        this.owner = owner;
        this.initVex();
        this.updateOnEntity();
    }

    protected void updateOnEntity() {
        if (this.vex.isRemoved()) {
            return;
        }
        CraftLivingEntity bukkitVex = this.vex.getBukkitLivingEntity();
        if (this.vex.distanceTo((Entity)this.owner) > 24.0f) {
            CraftHumanEntity bukkitOwner = this.owner.getBukkitEntity();
            bukkitVex.teleportAsync(bukkitOwner.getLocation().add(-1.0, 0.0, -1.0)).thenRun(() -> this.vex.getMoveControl().setWantedPosition(this.vex.getX(), this.vex.getY(), this.vex.getZ(), 2.0));
        }
        if (this.owner.isRemoved()) {
            bukkitVex.remove();
            return;
        }
        bukkitVex.getScheduler().runDelayed((Plugin)FeatherMorphMain.getInstance(), task -> this.updateOnEntity(), () -> {}, 2L);
    }

    protected void initVex() {
        this.vex.targetSelector.removeAllGoals(goal -> true);
        this.vex.targetSelector.addGoal(0, (Goal)new MorphOwnerHurtTargetGoal(this.vex, this));
        this.vex.targetSelector.addGoal(1, (Goal)new MorphOwnerHurtByTargetGoal(this.vex, this));
    }

    public Player getNMSOwner() {
        return this.owner;
    }

    public net.minecraft.world.entity.monster.Vex getNMSVex() {
        return this.vex;
    }

    public org.bukkit.entity.Player getOwner() {
        return (org.bukkit.entity.Player)this.owner.getBukkitEntity();
    }

    public Vex getVex() {
        return (Vex)this.vex.getBukkitLivingEntity();
    }

    private static class MorphOwnerHurtTargetGoal
    extends TargetGoal {
        private final net.minecraft.world.entity.monster.Vex thisEntity;
        private final MorphBukkitVexHolder wrapper;

        @NotNull
        private net.minecraft.world.entity.LivingEntity owner() {
            return this.wrapper.getNMSOwner();
        }

        public MorphOwnerHurtTargetGoal(net.minecraft.world.entity.monster.Vex thisEntity, MorphBukkitVexHolder wrapper) {
            super((Mob)thisEntity, false);
            Objects.requireNonNull(thisEntity, "Null Entity");
            Objects.requireNonNull(wrapper, "Null Wrapper");
            this.wrapper = wrapper;
            this.thisEntity = thisEntity;
            this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean canUse() {
            boolean canUse;
            net.minecraft.world.entity.LivingEntity lastHurt = this.owner().getLastHurtMob();
            boolean bl = canUse = lastHurt != null && this.canAttack(lastHurt, TargetingConditions.DEFAULT) && this.owner().tickCount - this.owner().getLastHurtMobTimestamp() < 20;
            if (canUse) {
                this.targetMob = lastHurt;
            }
            return canUse;
        }

        public void start() {
            super.start();
            this.thisEntity.getMoveControl().setWantedPosition(this.thisEntity.getX(), this.thisEntity.getY(), this.thisEntity.getZ(), 2.0);
            if (this.targetMob != null && this.targetMob.isRemoved()) {
                this.targetMob = null;
            }
            ((Vex)this.thisEntity.getBukkitLivingEntity()).setTarget((LivingEntity)this.targetMob.getBukkitLivingEntity());
        }
    }

    private static class MorphOwnerHurtByTargetGoal
    extends TargetGoal {
        private final net.minecraft.world.entity.monster.Vex thisEntity;
        private final MorphBukkitVexHolder wrapper;

        @NotNull
        private net.minecraft.world.entity.LivingEntity owner() {
            return this.wrapper.getNMSOwner();
        }

        public MorphOwnerHurtByTargetGoal(net.minecraft.world.entity.monster.Vex thisEntity, MorphBukkitVexHolder wrapper) {
            super((Mob)thisEntity, false);
            this.thisEntity = thisEntity;
            this.wrapper = wrapper;
        }

        public boolean canUse() {
            boolean canUse;
            net.minecraft.world.entity.LivingEntity owner = this.owner();
            net.minecraft.world.entity.LivingEntity lastHurtBy = owner.getLastHurtByMob();
            boolean bl = canUse = lastHurtBy != null && this.canAttack(lastHurtBy, TargetingConditions.DEFAULT) && owner.tickCount - owner.getLastHurtByMobTimestamp() < 20;
            if (canUse) {
                this.targetMob = lastHurtBy;
            }
            return canUse;
        }

        public void start() {
            super.start();
            if (this.targetMob != null && this.targetMob.isRemoved()) {
                this.targetMob = null;
            }
            this.thisEntity.getMoveControl().setWantedPosition(this.thisEntity.getX(), this.thisEntity.getY(), this.thisEntity.getZ(), 2.0);
            ((Vex)this.thisEntity.getBukkitLivingEntity()).setTarget((LivingEntity)this.targetMob.getBukkitLivingEntity());
        }
    }
}

