/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.skins;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.mojang.authlib.GameProfile;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.utilities.NbtUtils;

public class SingleSkin {
    @Expose
    @SerializedName(value="name")
    public String name = "unknown";
    @Expose
    @SerializedName(value="profile")
    public String snbt = "{}";
    @Expose
    @SerializedName(value="expires_at")
    public long expiresAt;
    @Nullable
    public GameProfile cachedProfile;

    public static SingleSkin fromProfile(GameProfile profile) {
        SingleSkin instance = new SingleSkin();
        instance.name = profile.name();
        instance.snbt = NbtUtils.getCompoundString(NbtUtils.toCompoundTag(profile));
        instance.cachedProfile = profile;
        instance.expiresAt = System.currentTimeMillis() + 1296000000L;
        return instance;
    }

    @Nullable
    public GameProfile generateGameProfile() {
        if (this.cachedProfile != null) {
            return this.cachedProfile;
        }
        if (this.snbt == null || this.snbt.equalsIgnoreCase("{}")) {
            return null;
        }
        this.cachedProfile = NbtUtils.readGameProfile(this.snbt);
        return this.cachedProfile;
    }
}

