/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.platform.impl.paper;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Unmodifiable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.misc.CacheWithDefault;
import xyz.nifeather.morph.platform.IPlatform;
import xyz.nifeather.morph.platform.entity.IPlatformEntity;
import xyz.nifeather.morph.platform.entity.IPlatformEntityLookup;
import xyz.nifeather.morph.platform.entity.IPlatformPlayer;
import xyz.nifeather.morph.platform.impl.paper.entity.PaperEntity;
import xyz.nifeather.morph.platform.impl.paper.entity.PaperEntityLookup;
import xyz.nifeather.morph.platform.impl.paper.world.PaperWorldLookup;

public class PaperPlatform
implements IPlatform<LivingEntity, Player, World, Location> {
    private final CacheWithDefault<List<Player>> nativeCachedOnlinePlayers = new CacheWithDefault(List.of());
    private final CacheWithDefault<List<IPlatformPlayer>> cachedOnlinePlayers = new CacheWithDefault(List.of());
    private final PaperEntityLookup entityLookup = new PaperEntityLookup();
    private final PaperWorldLookup worldLookup = new PaperWorldLookup();

    private FeatherMorphMain plugin() {
        return FeatherMorphMain.getInstance();
    }

    @Override
    public List<Player> onlinePlayersNative() {
        return ImmutableList.copyOf((Collection)Bukkit.getOnlinePlayers());
    }

    private IPlatformPlayer toPlatformPlayer(Player bukkitPlayer) {
        return this.entityLookup.getPlatformPlayer(bukkitPlayer);
    }

    @Override
    public @Unmodifiable List<IPlatformPlayer> onlinePlayers() {
        List<Player> nativeOnline = this.onlinePlayersNative();
        if (nativeOnline.hashCode() == this.nativeCachedOnlinePlayers.get().hashCode()) {
            return this.cachedOnlinePlayers.get();
        }
        List<IPlatformPlayer> newList = nativeOnline.stream().map(this::toPlatformPlayer).toList();
        this.nativeCachedOnlinePlayers.set(nativeOnline);
        this.cachedOnlinePlayers.set(newList);
        return newList;
    }

    @Override
    public IPlatformEntityLookup<LivingEntity, Player> entityLookup() {
        return this.entityLookup;
    }

    public PaperWorldLookup worldLookup() {
        return this.worldLookup;
    }

    @Override
    public void runDelayed(Runnable r, int delay) {
        delay = Math.max(1, delay);
        Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this.plugin(), task -> r.run(), (long)delay);
    }

    @Override
    public void runAsyncDelayed(Runnable r, int delay) {
        if (delay > 0) {
            Bukkit.getAsyncScheduler().runDelayed((Plugin)this.plugin(), task -> r.run(), (long)delay, TimeUnit.MILLISECONDS);
        } else {
            Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin(), task -> r.run());
        }
    }

    @Override
    public void runAtEntityDelayedNative(Entity entity, Runnable r, int delay) {
        delay = Math.max(1, delay);
        entity.getScheduler().runDelayed((Plugin)this.plugin(), task -> r.run(), null, (long)delay);
    }

    @Override
    public void runAtEntityDelayed(IPlatformEntity entity, Runnable r, int delay) {
        this.runAtEntityDelayedNative((Entity)((PaperEntity)entity).getHandle(), r, delay);
    }

    @Override
    public void runAtLocationDelayedNative(Location location, Runnable r, int delay) {
        delay = Math.max(1, delay);
        Bukkit.getRegionScheduler().runDelayed((Plugin)this.plugin(), location, task -> r.run(), (long)delay);
    }
}

