/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.skills.impl;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.api.morphs.skills.SkillNames;
import xyz.nifeather.morph.messages.strings.SkillStrings;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.ExecutionErrorException;
import xyz.nifeather.morph.skills.MorphSkill;
import xyz.nifeather.morph.skills.options.TeleportConfiguration;

public class TeleportMorphSkill
extends MorphSkill<TeleportConfiguration> {
    @Override
    public ISkillAbilityOptionHandler<TeleportConfiguration> optionHandler() {
        return TeleportConfiguration.OPTION_HANDLER;
    }

    @Override
    public int executeSkill(Player player, DisguiseState state, TeleportConfiguration option) throws ExecutionErrorException {
        if (option == null) {
            throw ExecutionErrorException.forMethod("executeSkill").withMessage("No option set for teleport skill").create();
        }
        Block targetBlock = player.getTargetBlockExact(option.getMaxDistance(), FluidCollisionMode.ALWAYS);
        if (targetBlock == null || targetBlock.getBlockData().getMaterial().isAir() || targetBlock.getBlockData().getMaterial().equals((Object)Material.WATER)) {
            this.sendDenyMessageToPlayer(player, SkillStrings.targetNotSuitableString());
            return 20;
        }
        Location loc = targetBlock.getLocation();
        BlockFace face = player.getTargetBlockFace(option.getMaxDistance());
        float commonOffset = 0.5f;
        float xOffset = 0.0f;
        float zOffset = 0.0f;
        float yOffset = 0.0f;
        assert (face != null);
        xOffset = face.getModX();
        zOffset = face.getModZ();
        yOffset = face.getModY();
        loc.setX(loc.getX() + (double)xOffset + (double)commonOffset);
        loc.setZ(loc.getZ() + (double)zOffset + (double)commonOffset);
        loc.setY(loc.getY() + (double)yOffset);
        loc.setDirection(player.getEyeLocation().getDirection());
        if (face == BlockFace.DOWN) {
            BoundingBox box = player.getBoundingBox();
            double height = box.getHeight();
            RayTraceResult traceResult = targetBlock.getWorld().rayTraceBlocks(loc, new Vector(0.0, -height, 0.0), height + 0.05, FluidCollisionMode.NEVER, true);
            if (traceResult == null || traceResult.getHitBlock() == null) {
                loc.setY(loc.getY() - player.getBoundingBox().getHeight() + 1.0);
            }
        }
        this.playSoundToNearbyPlayers(player, 10, Key.key((String)"minecraft", (String)"entity.enderman.teleport"), Sound.Source.HOSTILE);
        player.teleportAsync(loc).thenRun(() -> this.playSoundToNearbyPlayers(player, 10, Key.key((String)"minecraft", (String)"entity.enderman.teleport"), Sound.Source.HOSTILE));
        player.setFallDistance(0.0f);
        return 0;
    }

    @Override
    @NotNull
    public NamespacedKey getIdentifier() {
        return SkillNames.TELEPORT;
    }
}

