/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.skills.options;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.storage.skill.ISkillAbilityOption;

public class TeleportConfiguration
implements ISkillAbilityOption {
    public static TeleportOptionHandler OPTION_HANDLER = new TeleportOptionHandler();
    private final int maxDistance;

    public TeleportConfiguration(int maxDistance) {
        this.maxDistance = maxDistance;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public static class TeleportOptionHandler
    implements ISkillAbilityOptionHandler<TeleportConfiguration> {
        @Override
        public Class<TeleportConfiguration> getOptionClass() {
            return TeleportConfiguration.class;
        }

        @Override
        public void writeOption(TeleportConfiguration option, @NotNull Map<String, Object> gsonMap) {
            gsonMap.put("max_distance", option.getMaxDistance());
        }

        @Override
        @NotNull
        public TeleportConfiguration readOption(@NotNull Map<String, Object> gsonMap) throws ParseErrorException {
            int maxDistance = this.utilGetTypedOrThrow("max_distance", gsonMap, Number.class).intValue();
            return new TeleportConfiguration(maxDistance);
        }
    }
}

