/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.api.utilties.v0;

import java.util.UUID;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.api.direct.FeatherMorphDirectAccess;
import xyz.nifeather.morph.backends.DisguiseWrapper;
import xyz.nifeather.morph.backends.server.ServerDisguiseWrapper;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.SingleWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntries;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.disguiseProperty.values.OffTreeProperties;
import xyz.nifeather.morph.network.server.MessageChannel;

@ApiStatus.Experimental
public class UtilitiesAlpha {
    private final FeatherMorphDirectAccess directAccess;

    public UtilitiesAlpha(FeatherMorphDirectAccess directAccess) {
        this.directAccess = directAccess;
    }

    public boolean isPlayerDisguising(Player player) {
        MorphManager morphManager = this.directAccess.morphManager();
        return morphManager.getDisguiseStateFor(player) != null;
    }

    @Nullable
    public Player lookupPlayerFromDisguiseUUID(UUID input) {
        MorphManager morphManager = this.directAccess.morphManager();
        for (DisguiseState state : morphManager.getActiveDisguises()) {
            UUID uuid;
            ServerDisguiseWrapper wrapper;
            SingleWatcher watcher;
            DisguiseWrapper<?> disguiseWrapper = state.getDisguiseWrapper();
            if (!(disguiseWrapper instanceof ServerDisguiseWrapper) || (watcher = (wrapper = (ServerDisguiseWrapper)disguiseWrapper).getBindingWatcher()) == null || (uuid = (UUID)watcher.readEntryOrDefault(CustomEntries.SPAWN_UUID, null)) == null || !uuid.equals(input)) continue;
            return state.getPlayer();
        }
        return null;
    }

    public boolean isServerBackend() {
        MorphManager morphManager = this.directAccess.morphManager();
        return morphManager.getDefaultBackend().getIdentifier().equals("server");
    }

    @Nullable
    public UUID lookupDisguiseUUIDFromPlayer(Player input) {
        MorphManager morphManager = this.directAccess.morphManager();
        DisguiseState state = morphManager.getDisguiseStateFor(input);
        if (state == null) {
            return null;
        }
        return state.getDisguiseWrapper().readPropertyOr(OffTreeProperties.VIRTUAL_ENTITY_UUID, null);
    }

    public String[] getPreferredPluginChannels() {
        return MessageChannel.preferredChannels();
    }

    public String[] getAllPluginChannels() {
        return MessageChannel.allValidChannels();
    }
}

