/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import net.minecraft.nbt.CompoundTag;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.values.SnowGolemValues;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.LivingEntityWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.SnowGolemProperties;

public class SnowGolemWatcher
extends LivingEntityWatcher {
    public SnowGolemWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.SNOW_GOLEM);
    }

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.SNOW_GOLEM);
    }

    @Override
    protected <X> void onPropertyWrite(SingleProperty<X> property, X value) {
        SnowGolemProperties snowmanProperties = DisguiseProperties.INSTANCE.getOrThrow(SnowGolemProperties.class);
        if (property.equals(snowmanProperties.HAS_PUMPKIN)) {
            Boolean val = (Boolean)value;
            this.writePersistent(ValueIndex.SNOW_GOLEM.HAT_FLAGS, val != false ? SnowGolemValues.HAS_PUMPKIN : SnowGolemValues.NO_PUMPKIN);
        }
        super.onPropertyWrite(property, value);
    }

    @Override
    public void writeToCompound(CompoundTag nbt) {
        super.writeToCompound(nbt);
        Byte hatFlag = this.read(ValueIndex.SNOW_GOLEM.HAT_FLAGS);
        nbt.putBoolean("Pumpkin", hatFlag == SnowGolemValues.HAS_PUMPKIN);
    }
}

