/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.listeners;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.manager.player.PlayerManager;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.api.FeatherMorphAPI;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.SingleWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.RenderRegistry;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;

public abstract class ProtocolListener
extends MorphPluginObject
implements PacketListener {
    @Resolved(shouldSolveImmediately=true)
    private RenderRegistry registry;

    public abstract String getIdentifier();

    protected PlayerManager playerManager() {
        return PacketEvents.getAPI().getPlayerManager();
    }

    @Nullable
    protected Player getPlayerFrom(int id) {
        return this.featherMorph().getPlatform().onlinePlayersNative().stream().filter(p -> p.getEntityId() == id).findFirst().orElse(null);
    }

    protected void handleException(@Nullable Player sourcePlayer, SingleWatcher watcher, Throwable t) {
        DisguiseState state;
        boolean handled = false;
        FeatherMorphAPI api = FeatherMorphAPI.instance();
        if (api != null && (state = api.directAccess().morphManager().getDisguiseStateFor(sourcePlayer)) != null) {
            this.logger.info("Failed processing packet, calling DisguiseState#handleException");
            state.handleException(t);
            handled = true;
        }
        if (!handled) {
            this.logger.error("Unhandled exception when processing packet", t);
            this.registry.unregister(watcher.bindingUUID);
        }
    }
}

