/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.commands.brigadier.IConvertibleBrigadier;
import xyz.nifeather.morph.messages.strings.HelpStrings;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class MorphPlayerCommand
extends MorphPluginObject
implements IConvertibleBrigadier {
    @Resolved
    private MorphManager morphManager;

    @Override
    public String name() {
        return "morphplayer";
    }

    @Override
    public boolean register(Commands dispatcher) {
        dispatcher.register(((LiteralArgumentBuilder)Commands.literal((String)this.name()).then((ArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"who", (ArgumentType)StringArgumentType.word()).executes(this::executes)).suggests(this::suggests))).build());
        return true;
    }

    public int executes(CommandContext<CommandSourceStack> context) {
        Entity entity = ((CommandSourceStack)context.getSource()).getExecutor();
        if (!(entity instanceof Player)) {
            return 1;
        }
        Player player = (Player)entity;
        String targetName = StringArgumentType.getString(context, (String)"who");
        player.performCommand("morph " + DisguiseTypes.PLAYER.toId(targetName));
        return 1;
    }

    @NotNull
    public CompletableFuture<Suggestions> suggests(CommandContext<CommandSourceStack> context, SuggestionsBuilder suggestionsBuilder) {
        Entity entity = ((CommandSourceStack)context.getSource()).getExecutor();
        if (!(entity instanceof Player)) {
            return CompletableFuture.completedFuture(suggestionsBuilder.build());
        }
        Player player = (Player)entity;
        String input = suggestionsBuilder.getRemainingLowerCase();
        List<DisguiseMeta> availableDisguises = this.morphManager.getAvaliableDisguisesFor(player);
        return CompletableFuture.supplyAsync(() -> {
            Stream<DisguiseMeta> infoStream = availableDisguises.stream().filter(DisguiseMeta::isPlayerDisguise);
            infoStream.forEach(info -> {
                if (info.playerDisguiseTargetName.toLowerCase().contains(input)) {
                    suggestionsBuilder.suggest(info.playerDisguiseTargetName);
                }
            });
            return suggestionsBuilder.build();
        });
    }

    @Override
    public FormattableMessage getHelpMessage() {
        return HelpStrings.morphPlayerDescription();
    }
}

