/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands.subcommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.commands.brigadier.BrigadierCommand;
import xyz.nifeather.morph.config.ConfigOption;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.strings.CommandStrings;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.BindableList;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;
import xyz.nifeather.morph.utilities.BindableUtils;

public class OptionSubCommands {

    public static class BooleanOptionCommand
    extends BasicOptionCommand<Boolean> {
        private final List<String> booleanValues = List.of("true", "false");

        public BooleanOptionCommand(String name, MorphConfigManager config, ConfigOption option) {
            super(name, config, option);
        }

        @Override
        public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
            parentBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)this.name).executes(this::executes)).then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).suggests(this::suggests).executes(this::execSetConfig)));
            super.registerAsChild(parentBuilder);
        }

        public int executes(CommandContext<CommandSourceStack> context) {
            this.lookupConfig(((CommandSourceStack)context.getSource()).getSender(), Boolean.class);
            return 1;
        }

        private int execSetConfig(CommandContext<CommandSourceStack> context) {
            boolean value = BoolArgumentType.getBool(context, (String)"value");
            this.setConfig(((CommandSourceStack)context.getSource()).getSender(), value);
            return 1;
        }

        @NotNull
        public CompletableFuture<Suggestions> suggests(CommandContext<CommandSourceStack> context, SuggestionsBuilder suggestionsBuilder) {
            return CompletableFuture.supplyAsync(() -> {
                String input = suggestionsBuilder.getRemainingLowerCase();
                this.booleanValues.stream().filter(bv -> bv.contains(input)).forEach(arg_0 -> ((SuggestionsBuilder)suggestionsBuilder).suggest(arg_0));
                return suggestionsBuilder.build();
            });
        }

        @Override
        public String getPermissionRequirement() {
            return null;
        }

        @Override
        public FormattableMessage getHelpMessage() {
            return null;
        }
    }

    public static class IntegerOptionCommand
    extends BasicOptionCommand<Integer> {
        private int min = Integer.MIN_VALUE;
        private int max = Integer.MAX_VALUE;

        public IntegerOptionCommand(String name, MorphConfigManager configManager, ConfigOption option) {
            super(name, configManager, option);
        }

        public IntegerOptionCommand min(int min) {
            this.min = min;
            return this;
        }

        public IntegerOptionCommand max(int max) {
            this.max = max;
            return this;
        }

        public IntegerOptionCommand withRange(int min, int max) {
            this.min = min;
            this.max = max;
            return this;
        }

        @Override
        public String getPermissionRequirement() {
            return null;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
            parentBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)this.name).executes(this::executes)).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)this.min, (int)this.max)).executes(this::execSetConfig)));
            super.registerAsChild(parentBuilder);
        }

        public int executes(CommandContext<CommandSourceStack> context) {
            this.lookupConfig(((CommandSourceStack)context.getSource()).getSender(), Integer.class);
            return 1;
        }

        private int execSetConfig(CommandContext<CommandSourceStack> context) {
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            this.setConfig(sender, IntegerArgumentType.getInteger(context, (String)"value"));
            return 1;
        }

        @Override
        public FormattableMessage getHelpMessage() {
            return null;
        }
    }

    protected static class OperationListCommand
    extends OperationCommand {
        public OperationListCommand(MorphConfigManager configManager, ConfigOption option, String optionName) {
            super(configManager, option, optionName);
        }

        @Override
        public String getPermissionRequirement() {
            return null;
        }

        @Override
        public String name() {
            return "list";
        }

        @Override
        public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
            parentBuilder.then(Commands.literal((String)this.name()).executes(this::executes));
            super.registerAsChild(parentBuilder);
        }

        public int executes(CommandContext<CommandSourceStack> context) {
            BindableList<String> bindableList = this.configManager.getBindableList(String.class, this.configOption);
            String displayValue = BindableUtils.bindableListToString(bindableList);
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            MessageUtils.send(sender, CommandStrings.optionValueString().resolve("what", this.optionName).resolve("value", displayValue));
            return 1;
        }

        @Override
        public FormattableMessage getHelpMessage() {
            return null;
        }
    }

    protected static class OperationAddCommand
    extends OperationCommand {
        public OperationAddCommand(MorphConfigManager configManager, ConfigOption option, String optionName) {
            super(configManager, option, optionName);
        }

        @Override
        public String getPermissionRequirement() {
            return null;
        }

        @Override
        public String name() {
            return "add";
        }

        @Override
        public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
            parentBuilder.then(Commands.literal((String)this.name()).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(this::executes)));
            super.registerAsChild(parentBuilder);
        }

        public int executes(CommandContext<CommandSourceStack> context) {
            BindableList<String> bindableList = this.configManager.getBindableList(String.class, this.configOption);
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            String value = StringArgumentType.getString(context, (String)"value");
            try {
                bindableList.add(value);
                if (bindableList.contains(value)) {
                    MessageUtils.send(sender, CommandStrings.listAddSuccess().resolve("value", value).resolve("option", this.optionName));
                } else {
                    MessageUtils.send(sender, CommandStrings.listAddFailUnknown().resolve("value", value).resolve("option", this.optionName));
                }
            }
            catch (Throwable t) {
                MessageUtils.send(sender, CommandStrings.listAddFailUnknown().resolve("value", value).resolve("option", this.optionName));
                this.logger.error("Error adding option to bindable list: " + t.getMessage());
            }
            return 0;
        }

        @Override
        public FormattableMessage getHelpMessage() {
            return null;
        }
    }

    protected static class OperationRemoveCommand
    extends OperationCommand {
        public OperationRemoveCommand(MorphConfigManager configManager, ConfigOption option, String optionName) {
            super(configManager, option, optionName);
        }

        @Override
        public String getPermissionRequirement() {
            return null;
        }

        @Override
        public String name() {
            return "remove";
        }

        @Override
        public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
            parentBuilder.then(Commands.literal((String)this.name()).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(this::executes)));
            super.registerAsChild(parentBuilder);
        }

        public int executes(CommandContext<CommandSourceStack> context) {
            BindableList<String> bindableList = this.configManager.getBindableList(String.class, this.configOption);
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            String value = StringArgumentType.getString(context, (String)"value");
            boolean listChanged = bindableList.remove(value);
            if (listChanged) {
                MessageUtils.send(sender, CommandStrings.listRemoveSuccess().resolve("value", value).resolve("option", this.optionName));
            } else {
                MessageUtils.send(sender, CommandStrings.listRemoveFailUnknown().resolve("value", value).resolve("option", this.optionName));
            }
            return 1;
        }

        @Override
        public FormattableMessage getHelpMessage() {
            return null;
        }
    }

    private static abstract class OperationCommand
    extends BrigadierCommand {
        protected final MorphConfigManager configManager;
        protected final ConfigOption configOption;
        protected final String optionName;

        public OperationCommand(MorphConfigManager configManager, ConfigOption option, String optionName) {
            this.configManager = configManager;
            this.configOption = option;
            this.optionName = optionName;
        }
    }

    public static class StringListOptionBaseCommand
    extends BasicOptionCommand<List<String>> {
        public StringListOptionBaseCommand(String name, MorphConfigManager configManager, ConfigOption option) {
            super(name, configManager, option);
        }

        @Override
        public String getPermissionRequirement() {
            return null;
        }

        @Override
        public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
            OperationListCommand operationList = new OperationListCommand(this.config, this.option, this.name);
            OperationAddCommand operationAdd = new OperationAddCommand(this.config, this.option, this.name);
            OperationRemoveCommand operationRemove = new OperationRemoveCommand(this.config, this.option, this.name);
            LiteralArgumentBuilder thisBuilder = Commands.literal((String)this.name());
            operationList.registerAsChild((ArgumentBuilder<CommandSourceStack, ?>)thisBuilder);
            operationAdd.registerAsChild((ArgumentBuilder<CommandSourceStack, ?>)thisBuilder);
            operationRemove.registerAsChild((ArgumentBuilder<CommandSourceStack, ?>)thisBuilder);
            parentBuilder.then((ArgumentBuilder)thisBuilder);
        }

        @Override
        public FormattableMessage getHelpMessage() {
            return null;
        }
    }

    public static class LimiterStringListOptionCommand
    extends BasicOptionCommand<String> {
        private final List<String> knownValues;

        public LimiterStringListOptionCommand(String name, MorphConfigManager configManager, ConfigOption option, List<String> knownValues) {
            super(name, configManager, option);
            this.knownValues = knownValues;
        }

        @Override
        public String getPermissionRequirement() {
            return null;
        }

        @Override
        public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
            parentBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)this.name()).executes(this::executesNoArg)).then((ArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(this::execSetConfig)).suggests(this::suggests)));
            super.registerAsChild(parentBuilder);
        }

        public int executesNoArg(CommandContext<CommandSourceStack> context) {
            this.lookupConfig(((CommandSourceStack)context.getSource()).getSender(), String.class);
            return 0;
        }

        private int execSetConfig(CommandContext<CommandSourceStack> context) {
            String input = StringArgumentType.getString(context, (String)"value");
            String target = this.knownValues.stream().filter(str -> str.equalsIgnoreCase(input)).findFirst().orElse(null);
            if (target == null) {
                return 1;
            }
            this.setConfig(((CommandSourceStack)context.getSource()).getSender(), target);
            return 1;
        }

        @NotNull
        public CompletableFuture<Suggestions> suggests(CommandContext<CommandSourceStack> context, SuggestionsBuilder suggestionsBuilder) {
            return CompletableFuture.supplyAsync(() -> {
                String input = suggestionsBuilder.getRemainingLowerCase();
                this.knownValues.forEach(str -> {
                    String lowerCase = str.toLowerCase();
                    if (lowerCase.contains(input)) {
                        suggestionsBuilder.suggest(str);
                    }
                });
                return suggestionsBuilder.build();
            });
        }

        @Override
        public FormattableMessage getHelpMessage() {
            return null;
        }
    }

    protected static abstract class BasicOptionCommand<T>
    extends BrigadierCommand {
        protected final String name;
        protected final MorphConfigManager config;
        protected final ConfigOption option;

        protected BasicOptionCommand(String name, MorphConfigManager configManager, ConfigOption option) {
            this.name = name;
            this.config = configManager;
            this.option = option;
        }

        protected void setConfig(CommandSender sender, T value) {
            this.config.set(this.option, value);
            MessageUtils.send(sender, CommandStrings.optionSetString().resolve("what", this.name).resolve("value", String.valueOf(value)));
        }

        protected void lookupConfig(CommandSender sender, Class<?> type) {
            MessageUtils.send(sender, CommandStrings.optionValueString().resolve("what", this.name).resolve("value", String.valueOf(this.config.get(type, this.option))));
        }

        @Override
        public String name() {
            return this.name;
        }
    }
}

