/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands.subcommands.plugin;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.commands.brigadier.BrigadierCommand;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.strings.CommandStrings;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;
import xyz.nifeather.morph.storage.playerdata.PlayerMeta;

public class LookupSubCommand
extends BrigadierCommand {
    @Resolved(shouldSolveImmediately=true)
    private MorphManager manager;

    @Override
    @NotNull
    public String name() {
        return "lookup";
    }

    @Override
    @Nullable
    public String getPermissionRequirement() {
        return "feathermorph.lookup";
    }

    @Override
    public FormattableMessage getHelpMessage() {
        return new FormattableMessage(this.plugin, "lookup");
    }

    @Override
    public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
        parentBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)"lookup").requires(this::checkPermission)).then(((RequiredArgumentBuilder)Commands.argument((String)"who", (ArgumentType)StringArgumentType.string()).executes(this::execWithName)).then(Commands.argument((String)"filter", (ArgumentType)StringArgumentType.string()).executes(this::execWithNameFilter))));
        super.registerAsChild(parentBuilder);
    }

    private int execWithName(CommandContext<CommandSourceStack> context) {
        String targetLookupName = StringArgumentType.getString(context, (String)"who");
        this.doLookup(((CommandSourceStack)context.getSource()).getSender(), targetLookupName, null);
        return 1;
    }

    private int execWithNameFilter(CommandContext<CommandSourceStack> context) {
        String targetLookupName = StringArgumentType.getString(context, (String)"who");
        String filterName = StringArgumentType.getString(context, (String)"filter");
        this.doLookup(((CommandSourceStack)context.getSource()).getSender(), targetLookupName, filterName);
        return 1;
    }

    private void doLookup(CommandSender sender, String who, @Nullable String filterName) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)who);
        PlayerMeta configuration = this.manager.getPlayerMeta(offlinePlayer);
        List<String> matches = filterName != null ? configuration.getUnlockedDisguiseIdentifiers().stream().filter(k -> k.toUpperCase().contains(filterName.toUpperCase())).toList() : configuration.getUnlockedDisguiseIdentifiers();
        MessageUtils.send(sender, CommandStrings.lookupFilterCommand());
        matches.forEach(m -> MessageUtils.send(sender, m));
    }
}

