/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.messages.vanilla;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.shaded.pluginbase.Messages.IStrings;
import xyz.nifeather.morph.shaded.pluginbase.Messages.MessageStore;

public abstract class BasicVanillaMessageStore
extends MessageStore<FeatherMorphMain> {
    protected final String langDirUri;
    protected final File langDir;
    private final String urlPattern;

    public BasicVanillaMessageStore() {
        this.langDirUri = String.valueOf(this.plugin.getDataFolder().toURI()) + "/mclang";
        this.langDir = new File(URI.create(this.langDirUri));
        this.urlPattern = "https://raw.githubusercontent.com/InventivetalentDev/minecraft-assets/" + Bukkit.getMinecraftVersion() + "/assets/minecraft/lang/";
    }

    @NotNull
    protected abstract String getLocaleCode();

    @Override
    @NotNull
    protected String getFileName() {
        return "mclang/" + this.getLocaleCode() + ".json";
    }

    @Override
    protected List<Class<? extends IStrings>> getStrings() {
        return new ArrayList<Class<? extends IStrings>>();
    }

    @Override
    protected String getPluginNamespace() {
        return FeatherMorphMain.getMorphNameSpace();
    }

    @Override
    public void initializeStorage() {
        super.initializeStorage();
        if (((Map)this.storingObject).isEmpty()) {
            this.downloadLanguage();
        }
    }

    protected void downloadLanguage() {
        boolean result;
        this.logger.info("Downloading Minecraft localization for language " + this.getLocaleCode() + "...");
        if (!this.langDir.exists() && !(result = this.langDir.mkdirs())) {
            this.logger.error("Unable to create directory '" + String.valueOf(this.langDir) + "', download cancelled.");
            return;
        }
        File targetFile = new File(URI.create(this.langDirUri + "/" + this.getLocaleCode() + ".json"));
        targetFile.delete();
        if (targetFile.exists() && !((Map)this.storingObject).isEmpty()) {
            return;
        }
        this.addSchedule(() -> {
            block11: {
                try {
                    String str;
                    URL req = new URL(this.urlPattern + this.getLocaleCode() + ".json");
                    HttpURLConnection con = (HttpURLConnection)req.openConnection();
                    this.logger.info("Downloading from " + String.valueOf(req));
                    con.setRequestMethod("GET");
                    con.setInstanceFollowRedirects(true);
                    con.setReadTimeout(3000);
                    con.setConnectTimeout(3000);
                    StringBuilder builder = new StringBuilder();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
                    while ((str = reader.readLine()) != null) {
                        builder.append(str).append("\n");
                    }
                    boolean success = con.getResponseCode() == 200;
                    con.disconnect();
                    if (success) {
                        try (FileOutputStream stream = new FileOutputStream(targetFile);){
                            stream.write(builder.toString().getBytes());
                            this.addSchedule(this::reloadConfiguration);
                            this.logger.info("Successfully downloaded Minecraft localization for language " + this.getLocaleCode() + "!");
                            break block11;
                        }
                        catch (IOException e) {
                            this.logger.error("Error occurred while writing data for language " + this.getLocaleCode(), (Throwable)e);
                        }
                        break block11;
                    }
                    this.logger.warn("Unable to download Minecraft localization for language" + this.getLocaleCode() + ": " + con.getResponseCode() + " :: " + con.getRequestMethod());
                }
                catch (Throwable t) {
                    this.logger.error("Unable to create request for language " + this.getLocaleCode() + ": " + t.getMessage());
                }
            }
        }, 0, true);
    }
}

