/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class BoundingBoxLookup {
    private static final BoundingBoxLookup instance = new BoundingBoxLookup();
    private final Map<EntityType, BoundingBox> boundingBoxMap = new ConcurrentHashMap<EntityType, BoundingBox>();

    public static BoundingBoxLookup instance() {
        return instance;
    }

    @Nullable
    private BoundingBox lookupBoundingBox(EntityType type, Location executingLocation) {
        if (type == EntityType.UNKNOWN || !type.isAlive() || !type.isSpawnable()) {
            return null;
        }
        World world = executingLocation.getWorld();
        Entity entity = world.spawnEntity(executingLocation.clone().add(0.0, -4096.0, 0.0), type, CreatureSpawnEvent.SpawnReason.CUSTOM, Entity::remove);
        BoundingBox entityBox = entity.getBoundingBox();
        BoundingBox box = BoundingBox.of((Vector)new Vector(0.0, entityBox.getHeight() / 2.0, 0.0), (double)(entityBox.getWidthX() / 2.0), (double)(entityBox.getHeight() / 2.0), (double)(entityBox.getWidthZ() / 2.0));
        this.boundingBoxMap.put(type, box);
        return box;
    }

    public BoundingBox getBoundingBoxAt(EntityType type, Location location) {
        return this.getBoundboxOptional(type, location).map(b -> b.clone().shift(location)).orElse(BoundingBox.of((Location)location, (double)0.3, (double)0.9, (double)0.3).shift(0.0, 0.9, 0.0));
    }

    public Optional<BoundingBox> getBoundboxOptional(EntityType type, Location executingLocation) {
        return Optional.ofNullable(this.getBoundingBox(type, executingLocation));
    }

    @Nullable
    public BoundingBox getBoundingBox(EntityType type, Location executingLocation) {
        BoundingBox box = this.boundingBoxMap.getOrDefault(type, null);
        return box == null ? this.lookupBoundingBox(type, executingLocation) : box.clone();
    }
}

