/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc;

import java.util.HashMap;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.backends.DisguiseWrapper;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.admin.reveal.S2CAddAdminRevealCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRSetMetaCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CRenderMeta;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.utilities.MapMetaUtils;

public class ModNetworkingHelper
extends MorphPluginObject {
    @Resolved(shouldSolveImmediately=true)
    private MorphClientHandler clientHandler;

    public S2CAddAdminRevealCommand genPartialMapCommand(DisguiseState ... diff) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (DisguiseState disguiseState : diff) {
            Player player = disguiseState.getPlayer();
            map.put(player.getEntityId(), player.getName());
        }
        return new S2CAddAdminRevealCommand(map);
    }

    public void sendCommandToRevealablePlayers(AbstractS2CCommand<?> cmd) {
        List<Player> target = this.featherMorph().getPlatform().onlinePlayersNative().stream().filter(p -> p.hasPermission("feathermorph.disguise_revealing")).toList();
        target.forEach(p -> this.clientHandler.sendCommand((Player)p, cmd));
    }

    public void sendCommandToAllPlayers(AbstractS2CCommand<?> cmd) {
        this.featherMorph().getPlatform().onlinePlayersNative().forEach(p -> this.clientHandler.sendCommand((Player)p, cmd));
    }

    public NetworkDisguiseStateRecord prepareMeta(int networkId) {
        return new NetworkDisguiseStateRecord(networkId, this);
    }

    public NetworkDisguiseStateRecord prepareMeta(Entity entity) {
        return this.prepareMeta(entity.getEntityId());
    }

    public static class NetworkDisguiseStateRecord {
        private final ModNetworkingHelper bindingHelper;
        private final S2CRenderMeta renderMeta;

        public NetworkDisguiseStateRecord(int networkId, ModNetworkingHelper bindingHelper) {
            this.renderMeta = new S2CRenderMeta(networkId);
            this.bindingHelper = bindingHelper;
        }

        public NetworkDisguiseStateRecord setSNbt(String snbt) {
            this.renderMeta.sNbt = snbt;
            return this;
        }

        public NetworkDisguiseStateRecord setOverridedEquip(EntityEquipment equipment) {
            this.renderMeta.overridedEquipment = MapMetaUtils.toPacketEquipment(equipment);
            return this;
        }

        public NetworkDisguiseStateRecord setProfileCompound(String compoundString) {
            this.renderMeta.profileCompound = compoundString;
            return this;
        }

        public NetworkDisguiseStateRecord setDisguiseEquipmentShown(boolean newValue) {
            this.renderMeta.showOverridedEquipment = newValue;
            return this;
        }

        public NetworkDisguiseStateRecord forDisguiseState(DisguiseState state) {
            return this.forWrapper(state.getDisguiseWrapper());
        }

        public NetworkDisguiseStateRecord forWrapper(DisguiseWrapper<?> wrapper) {
            return this;
        }

        public S2CCRSetMetaCommand build() {
            return new S2CCRSetMetaCommand(this.renderMeta);
        }

        public void send() {
            this.bindingHelper.sendCommandToAllPlayers(this.build());
        }
    }
}

