/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.gui;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.config.ConfigOption;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.messages.strings.GuiStrings;
import xyz.nifeather.morph.messages.strings.MorphStrings;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.gui.IconLookup;
import xyz.nifeather.morph.misc.gui.PagerWithFallbackItem;
import xyz.nifeather.morph.misc.gui.ScreenWrapper;
import xyz.nifeather.morph.shaded.inventorygui.DynamicGuiElement;
import xyz.nifeather.morph.shaded.inventorygui.GuiElement;
import xyz.nifeather.morph.shaded.inventorygui.GuiElementGroup;
import xyz.nifeather.morph.shaded.inventorygui.GuiPageElement;
import xyz.nifeather.morph.shaded.inventorygui.InventoryGui;
import xyz.nifeather.morph.shaded.inventorygui.StaticGuiElement;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;

public class DisguiseSelectScreenWrapper
extends ScreenWrapper {
    @Nullable
    private final DisguiseState bindingState;
    private final List<DisguiseMeta> disguises;
    private final boolean playOpenSound;
    @Resolved(shouldSolveImmediately=true)
    private MorphManager manager;
    @Resolved(shouldSolveImmediately=true)
    private MorphConfigManager config;
    private final List<String> template = ObjectArrayList.of((Object[])new String[]{"CxDDDxPUN"});

    public DisguiseSelectScreenWrapper(Player bindingPlayer) {
        this(bindingPlayer, true);
    }

    protected DisguiseSelectScreenWrapper(Player bindingPlayer, boolean playOpenSound) {
        super(bindingPlayer);
        this.disguises = this.manager.getAvaliableDisguisesFor(bindingPlayer);
        this.bindingState = this.manager.getDisguiseStateFor(bindingPlayer);
        this.playOpenSound = playOpenSound;
        this.template.clear();
        this.template.addAll(this.config.getBindableList(String.class, ConfigOption.GUI_PATTERN));
        this.guiInstance = this.preparePage();
        this.initElements(this.guiInstance);
    }

    private List<String> getTemplate() {
        return this.template;
    }

    @Override
    public void show() {
        super.show();
        if (this.playOpenSound) {
            this.getBindingPlayer().playSound(openSound);
        }
    }

    protected void parseItemLore(ItemMeta itemMeta, List<String> strings) {
        ObjectArrayList loreList = new ObjectArrayList();
        strings.forEach(arg_0 -> this.lambda$parseItemLore$0((List)loreList, arg_0));
        itemMeta.lore((List)loreList);
    }

    protected void parseItemName(ItemMeta itemMeta, String s) {
        TextComponent component = Component.text((String)"???");
        try {
            component = MiniMessage.miniMessage().deserialize((Object)s);
        }
        catch (Throwable t) {
            this.logger.error("Can't deserialize string '%s': %s".formatted(s, t.getMessage()));
        }
        itemMeta.itemName((Component)component);
    }

    private InventoryGui preparePage() {
        List<String> template = this.getTemplate();
        if (template.size() > 6) {
            this.logger.error("May not have a inventory with more than 6 rows.");
            return new InventoryGui((Plugin)this.plugin, "missingno", new String[]{"         "}, new GuiElement[0]);
        }
        ObjectArrayList rows = new ObjectArrayList();
        for (String line : template) {
            if (line.length() != 9) {
                this.logger.warn("A line cannot have more or less than 9 characters, ignoring '%s'".formatted(line));
                continue;
            }
            rows.add(line.toUpperCase());
        }
        String[] array = rows.toArray(new String[0]);
        InventoryGui skel = new InventoryGui((Plugin)this.plugin, GuiStrings.selectDisguise().createString(this.playerLocale), array, new GuiElement[0]);
        skel.setItemNameSetter(this::parseItemName);
        skel.setItemLoreSetter(this::parseItemLore);
        skel.setCloseAction(close -> false);
        return skel;
    }

    private GuiElement getPageFill(DisguiseMeta meta) {
        String identifier = meta.rawIdentifier;
        Player bindingPlayer = this.getBindingPlayer();
        ItemStack item = IconLookup.instance().lookup(identifier);
        item.editMeta(m -> m.customName(meta.asComponent(this.playerLocale).decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE)));
        StaticGuiElement element = new StaticGuiElement('x', item, 1, click -> {
            bindingPlayer.playSound(clickSound);
            this.manager.morph((CommandSender)bindingPlayer, bindingPlayer, identifier, bindingPlayer.getTargetEntity(5));
            this.guiInstance.close();
            return true;
        }, new String[0]);
        if (meta.isPlayerDisguise()) {
            return new DynamicGuiElement('x', () -> element);
        }
        return element;
    }

    private void initElements(InventoryGui guiInstance) {
        Player bindingPlayer = this.getBindingPlayer();
        GuiElementGroup groupElement = new GuiElementGroup('D', new GuiElement[0]);
        ItemStack fallback = ItemStack.of((Material)Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        fallback.editMeta(meta -> meta.customName((Component)Component.empty()));
        for (DisguiseMeta disguiseMeta : this.disguises) {
            GuiElement element = this.getPageFill(disguiseMeta);
            if (disguiseMeta.isPlayerDisguise()) {
                this.isDynamic.set(true);
            }
            groupElement.addElement(element);
        }
        guiInstance.addElement(groupElement);
        PagerWithFallbackItem nextPageElement = new PagerWithFallbackItem('N', ItemStack.of((Material)Material.LIGHT_BLUE_STAINED_GLASS_PANE), fallback, GuiPageElement.PageAction.NEXT, GuiStrings.nextPage().createString(this.playerLocale));
        guiInstance.addElement(nextPageElement);
        PagerWithFallbackItem lastPageElement = new PagerWithFallbackItem('P', ItemStack.of((Material)Material.LIME_STAINED_GLASS_PANE), fallback, GuiPageElement.PageAction.PREVIOUS, GuiStrings.prevPage().createString(this.playerLocale));
        guiInstance.addElement(lastPageElement);
        guiInstance.setPageNumber(1);
        StaticGuiElement borderElement = new StaticGuiElement('X', new ItemStack(Material.PINK_STAINED_GLASS_PANE), 1, click -> true, "<i></i>");
        guiInstance.addElement(borderElement);
        StaticGuiElement unDisguiseButton = new StaticGuiElement('U', new ItemStack(Material.RED_STAINED_GLASS_PANE), 1, click -> {
            bindingPlayer.playSound(clickSound);
            this.manager.unMorph(bindingPlayer);
            this.guiInstance.close();
            return true;
        }, "<italic:false>" + GuiStrings.unDisguise().createString(this.playerLocale));
        guiInstance.addElement(unDisguiseButton);
        if (this.bindingState != null) {
            String name = "<italic:false>" + MorphStrings.disguisingAsString().resolve("what", this.bindingState.getPlayerDisplay()).createString(this.playerLocale);
            StaticGuiElement currentDisguiseButton = new StaticGuiElement('C', IconLookup.instance().lookup(this.bindingState.getDisguiseIdentifier()), 1, click -> true, name);
            guiInstance.addElement(currentDisguiseButton);
        } else {
            StaticGuiElement disguisePlaceholderElement = new StaticGuiElement('C', ItemStack.of((Material)Material.PINK_STAINED_GLASS_PANE), 1, click -> true, "<i></i>");
            guiInstance.addElement(disguisePlaceholderElement);
        }
    }

    private /* synthetic */ void lambda$parseItemLore$0(List loreList, String lore) {
        TextComponent component = Component.text((String)"???");
        try {
            component = MiniMessage.miniMessage().deserialize((Object)lore);
        }
        catch (Throwable t) {
            this.logger.error("Can't deserialize lore string '%s': %s".formatted(lore, t.getMessage()));
        }
        loreList.add(component);
    }
}

