/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.skins;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.skins.SingleSkin;
import xyz.nifeather.morph.misc.skins.SkinCacheRoot;
import xyz.nifeather.morph.storage.MorphJsonBasedStorage;

public class SkinCache
extends MorphJsonBasedStorage<SkinCacheRoot> {
    @Override
    @NotNull
    protected String getFileName() {
        return "stored_skins.json";
    }

    @Override
    @NotNull
    protected SkinCacheRoot createDefault() {
        return new SkinCacheRoot();
    }

    @Override
    @NotNull
    protected String getDisplayName() {
        return "Server renderer skin store";
    }

    public synchronized void cache(GameProfile profile) {
        this.drop(profile.name());
        ((SkinCacheRoot)this.storingObject).storedSkins.add(SingleSkin.fromProfile(profile));
        this.saveConfiguration();
    }

    public synchronized void drop(String name) {
        ((SkinCacheRoot)this.storingObject).storedSkins.removeIf(ss -> ss.name.equalsIgnoreCase(name));
        this.saveConfiguration();
    }

    public synchronized void drop(GameProfile profile) {
        this.drop(profile.name());
    }

    public synchronized void drop(SingleSkin singleSkin) {
        ((SkinCacheRoot)this.storingObject).storedSkins.remove(singleSkin);
        this.saveConfiguration();
    }

    public synchronized void dropAll() {
        ((SkinCacheRoot)this.storingObject).storedSkins.clear();
        this.saveConfiguration();
    }

    @Nullable
    SingleSkin getRaw(String name) {
        return ((SkinCacheRoot)this.storingObject).storedSkins.stream().filter(ss -> ss.name.equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    @NotNull
    public SkinRecord get(String name) {
        SingleSkin single = this.getRaw(name);
        if (single == null) {
            return new SkinRecord(Optional.empty(), true);
        }
        GameProfile profile = single.generateGameProfile();
        return new SkinRecord(profile == null ? Optional.empty() : Optional.of(profile), System.currentTimeMillis() > single.expiresAt);
    }

    public List<SingleSkin> listAll() {
        return new ObjectArrayList(((SkinCacheRoot)this.storingObject).storedSkins);
    }

    public record SkinRecord(Optional<GameProfile> profileOptional, boolean expired) {
    }
}

