/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.commands.S2C;

import java.util.Arrays;
import java.util.Map;
import xyz.nifeather.morph.network.BasicServerHandler;
import xyz.nifeather.morph.network.annotations.Environment;
import xyz.nifeather.morph.network.annotations.EnvironmentType;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.utils.Asserts;

public class S2CUpdateRequestStatusCommand
extends AbstractS2CCommand<String> {
    public final Type requestType;
    public final String source;

    public static S2CUpdateRequestStatusCommand fromArguments(Map<String, String> arguments) throws RuntimeException {
        String typeStr = Asserts.getStringOrThrow(arguments, "type");
        Type type = Arrays.stream(Type.values()).filter(t -> t.commandName.equalsIgnoreCase(typeStr)).findFirst().orElse(Type.Unknown);
        String source = Asserts.getStringOrThrow(arguments, "source");
        return new S2CUpdateRequestStatusCommand(type, source);
    }

    @Override
    public Map<String, String> generateArgumentMap() {
        return Map.of("type", this.requestType.commandName, "source", this.source);
    }

    public S2CUpdateRequestStatusCommand(Type requestType, String source) {
        this.requestType = requestType;
        this.source = source;
    }

    @Override
    public String getBaseName() {
        return "update_request_status";
    }

    @Override
    @Environment(value=EnvironmentType.CLIENT)
    public void onCommand(BasicServerHandler<?> handler) {
        handler.onExchangeRequestReceive(this);
    }

    public static enum Type {
        NewRequest("new"),
        RequestSend("send"),
        RequestExpired("expire"),
        RequestExpiredOwner("expire_owner"),
        RequestAccepted("request_accepted"),
        RequestDenied("request_denied"),
        Unknown("unknown_type");

        public final String commandName;

        public boolean isRequestOwner() {
            return this == RequestExpiredOwner || this == RequestSend || this == RequestAccepted || this == RequestDenied;
        }

        private Type(String cmdName) {
            this.commandName = cmdName;
        }
    }
}

