/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.fmccl.network.commands.C2S;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.fmccl.network.BasicClientHandler;
import xyz.nifeather.fmccl.network.annotations.Environment;
import xyz.nifeather.fmccl.network.annotations.EnvironmentType;

public abstract class NetheriteC2SCommand<T> {
    @NotNull
    protected List<T> arguments;
    private Object owner;

    public abstract String getBaseName();

    public NetheriteC2SCommand() {
        this.arguments = new ArrayList<T>();
    }

    public NetheriteC2SCommand(@Nullable T argument) {
        this.arguments = this.toList(argument);
    }

    public NetheriteC2SCommand(@Nullable T[] arguments) {
        this.arguments = this.toList(arguments);
    }

    protected List<T> toList(T ... elements) {
        if (elements == null) {
            return new ArrayList();
        }
        return Arrays.stream(elements).toList();
    }

    @Environment(value=EnvironmentType.SERVER)
    public abstract void onCommand(BasicClientHandler<?> var1);

    public <TPlayer> void setOwner(TPlayer player) {
        this.owner = player;
    }

    public <TPlayer> TPlayer getOwner() {
        return (TPlayer)this.owner;
    }

    public String buildCommand() {
        return (this.getBaseName() + " " + this.serializeArguments()).trim();
    }

    public String serializeArguments() {
        if (this.arguments.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (T argument : this.arguments) {
            builder.append(argument).append(" ");
        }
        return builder.toString();
    }

    @Nullable
    public T getArgumentAt(int index) {
        return index >= this.arguments.size() ? null : (T)this.arguments.get(index);
    }

    @NotNull
    public T getArgumentAt(int index, @NotNull T defaultValue) {
        T val = this.getArgumentAt(index);
        return val == null ? defaultValue : val;
    }
}

